/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class ContentType
implements Serializable {
    private static final long serialVersionUID = -7768694718232371896L;
    private static final String CHARSET = "charset";
    public static final ContentType APPLICATION_ATOM_XML = ContentType.create("application/atom+xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_NDJSON = ContentType.create("application/x-ndjson", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream", null);
    public static final ContentType APPLICATION_PDF = ContentType.create("application/pdf", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_SOAP_XML = ContentType.create("application/soap+xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_SVG_XML = ContentType.create("application/svg+xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_XHTML_XML = ContentType.create("application/xhtml+xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_PROBLEM_JSON = ContentType.create("application/problem+json", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_PROBLEM_XML = ContentType.create("application/problem+xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_RSS_XML = ContentType.create("application/rss+xml", StandardCharsets.UTF_8);
    public static final ContentType IMAGE_BMP = ContentType.create("image/bmp");
    public static final ContentType IMAGE_GIF = ContentType.create("image/gif");
    public static final ContentType IMAGE_JPEG = ContentType.create("image/jpeg");
    public static final ContentType IMAGE_PNG = ContentType.create("image/png");
    public static final ContentType IMAGE_SVG = ContentType.create("image/svg+xml");
    public static final ContentType IMAGE_TIFF = ContentType.create("image/tiff");
    public static final ContentType IMAGE_WEBP = ContentType.create("image/webp");
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data", StandardCharsets.ISO_8859_1);
    public static final ContentType MULTIPART_MIXED = ContentType.create("multipart/mixed", StandardCharsets.ISO_8859_1);
    public static final ContentType MULTIPART_RELATED = ContentType.create("multipart/related", StandardCharsets.ISO_8859_1);
    public static final ContentType TEXT_HTML = ContentType.create("text/html", StandardCharsets.UTF_8);
    public static final ContentType TEXT_MARKDOWN = ContentType.create("text/markdown", StandardCharsets.UTF_8);
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain", StandardCharsets.UTF_8);
    public static final ContentType TEXT_XML = ContentType.create("text/xml", StandardCharsets.UTF_8);
    public static final ContentType TEXT_EVENT_STREAM = ContentType.create("text/event-stream", StandardCharsets.UTF_8);
    public static final ContentType WILDCARD = ContentType.create("*/*", null);
    private static final NameValuePair[] EMPTY_NAME_VALUE_PAIR_ARRAY = new NameValuePair[0];
    @Deprecated
    private static final Map<String, ContentType> CONTENT_TYPE_MAP;
    public static final ContentType DEFAULT_TEXT;
    public static final ContentType DEFAULT_BINARY;
    private final String mimeType;
    private final Charset charset;
    private final NameValuePair[] params;

    ContentType(String string, Charset charset) {
        this.mimeType = string;
        this.charset = charset;
        this.params = null;
    }

    ContentType(String string, Charset charset, NameValuePair[] nameValuePairArray) {
        this.mimeType = string;
        this.charset = charset;
        this.params = nameValuePairArray;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final Charset getCharset() {
        return this.charset;
    }

    public final Charset getCharset(Charset charset) {
        if (this.charset != null) {
            return this.charset;
        }
        return charset;
    }

    public final String getParameter(String string) {
        Args.notEmpty(string, "Parameter name");
        if (this.params == null) {
            return null;
        }
        NameValuePair[] nameValuePairArray = this.params;
        int n2 = this.params.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            NameValuePair nameValuePair = nameValuePairArray[i2];
            if (!nameValuePair.getName().equalsIgnoreCase(string)) continue;
            return nameValuePair.getValue();
        }
        return null;
    }

    public final String toString() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        charArrayBuffer.append(this.mimeType);
        if (this.params != null) {
            charArrayBuffer.append("; ");
            MessageSupport.formatParameters(charArrayBuffer, this.params);
        } else if (this.charset != null) {
            charArrayBuffer.append("; charset=");
            charArrayBuffer.append(this.charset.name());
        }
        return charArrayBuffer.toString();
    }

    private static boolean valid(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '\"' && c2 != ',' && c2 != ';') continue;
            return false;
        }
        return true;
    }

    public static ContentType create(String string, Charset charset) {
        string = TextUtils.toLowerCase(Args.notBlank(string, "MIME type"));
        Args.check(ContentType.valid(string), "MIME type may not contain reserved characters");
        return new ContentType(string, charset);
    }

    public static ContentType create(String string) {
        return ContentType.create(string, null);
    }

    public static ContentType create(String string, String string2) throws UnsupportedCharsetException {
        return ContentType.create(string, !TextUtils.isBlank(string2) ? Charset.forName(string2) : null);
    }

    private static ContentType create(HeaderElement headerElement, boolean bl2) {
        String string = headerElement.getName();
        if (TextUtils.isBlank(string)) {
            return null;
        }
        return ContentType.create(headerElement.getName(), headerElement.getParameters(), bl2);
    }

    private static ContentType create(String string, NameValuePair[] nameValuePairArray, boolean bl2) {
        Charset charset = null;
        if (nameValuePairArray != null) {
            Object object = nameValuePairArray;
            int n2 = nameValuePairArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                NameValuePair nameValuePair = object[i2];
                if (!nameValuePair.getName().equalsIgnoreCase(CHARSET)) continue;
                object = nameValuePair.getValue();
                if (TextUtils.isBlank((CharSequence)object)) break;
                try {
                    charset = Charset.forName((String)object);
                    break;
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    if (!bl2) break;
                    throw unsupportedCharsetException;
                }
            }
        }
        return new ContentType(string, charset, nameValuePairArray != null && nameValuePairArray.length > 0 ? nameValuePairArray : null);
    }

    public static ContentType create(String string, NameValuePair ... nameValuePairArray) throws UnsupportedCharsetException {
        String string2 = TextUtils.toLowerCase(Args.notBlank(string, "MIME type"));
        Args.check(ContentType.valid(string2), "MIME type may not contain reserved characters");
        return ContentType.create(string, nameValuePairArray != null ? (NameValuePair[])nameValuePairArray.clone() : null, true);
    }

    public static ContentType parse(CharSequence charSequence) throws UnsupportedCharsetException {
        return ContentType.parse(charSequence, true);
    }

    public static ContentType parseLenient(CharSequence charSequence) {
        return ContentType.parse(charSequence, false);
    }

    private static ContentType parse(CharSequence object, boolean bl2) throws UnsupportedCharsetException {
        if (TextUtils.isBlank((CharSequence)object)) {
            return null;
        }
        ParserCursor parserCursor = new ParserCursor(0, object.length());
        AtomicReference atomicReference = new AtomicReference();
        MessageSupport.parseElements((CharSequence)object, parserCursor, headerElement -> atomicReference.compareAndSet(null, headerElement));
        object = (HeaderElement)atomicReference.get();
        if (object != null) {
            return ContentType.create((HeaderElement)object, bl2);
        }
        return null;
    }

    @Deprecated
    public static ContentType getByMimeType(String string) {
        if (string == null) {
            return null;
        }
        return CONTENT_TYPE_MAP.get(string);
    }

    public static Charset getCharset(ContentType contentType, Charset charset) {
        if (contentType != null) {
            return contentType.getCharset(charset);
        }
        return charset;
    }

    public final ContentType withCharset(Charset charset) {
        return ContentType.create(this.getMimeType(), charset);
    }

    public final ContentType withCharset(String string) {
        return ContentType.create(this.getMimeType(), string);
    }

    public final ContentType withParameters(NameValuePair ... nameValuePairArray) throws UnsupportedCharsetException {
        NameValuePair nameValuePair;
        int n2;
        int n3;
        Object object;
        if (nameValuePairArray.length == 0) {
            return this;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.params != null) {
            object = this.params;
            n3 = this.params.length;
            for (n2 = 0; n2 < n3; ++n2) {
                nameValuePair = object[n2];
                linkedHashMap.put(nameValuePair.getName(), nameValuePair.getValue());
            }
        }
        object = nameValuePairArray;
        n3 = nameValuePairArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            nameValuePair = object[n2];
            linkedHashMap.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        object = new ArrayList(linkedHashMap.size() + 1);
        if (this.charset != null && !linkedHashMap.containsKey(CHARSET)) {
            object.add(new BasicNameValuePair(CHARSET, this.charset.name()));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        return ContentType.create(this.getMimeType(), object.toArray(EMPTY_NAME_VALUE_PAIR_ARRAY), true);
    }

    public final boolean isSameMimeType(ContentType contentType) {
        return contentType != null && this.mimeType.equalsIgnoreCase(contentType.getMimeType());
    }

    static {
        ContentType[] contentTypeArray = new ContentType[]{APPLICATION_ATOM_XML, APPLICATION_FORM_URLENCODED, APPLICATION_JSON, APPLICATION_SVG_XML, APPLICATION_XHTML_XML, APPLICATION_XML, IMAGE_BMP, IMAGE_GIF, IMAGE_JPEG, IMAGE_PNG, IMAGE_SVG, IMAGE_TIFF, IMAGE_WEBP, MULTIPART_FORM_DATA, TEXT_HTML, TEXT_PLAIN, TEXT_XML};
        HashMap<String, ContentType> hashMap = new HashMap<String, ContentType>();
        int cfr_ignored_0 = contentTypeArray.length;
        for (int i2 = 0; i2 < 17; ++i2) {
            ContentType contentType = contentTypeArray[i2];
            hashMap.put(contentType.getMimeType(), contentType);
        }
        CONTENT_TYPE_MAP = Collections.unmodifiableMap(hashMap);
        DEFAULT_TEXT = TEXT_PLAIN;
        DEFAULT_BINARY = APPLICATION_OCTET_STREAM;
    }
}

