/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.net.Host;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class HttpHost
implements Serializable,
NamedEndpoint {
    private static final long serialVersionUID = -7529410654042457626L;
    public static final URIScheme DEFAULT_SCHEME = URIScheme.HTTP;
    private final String schemeName;
    private final Host host;
    private final InetAddress address;

    public HttpHost(String string, InetAddress inetAddress, String string2, int n2) {
        Args.containsNoBlanks(string2, "Host name");
        this.host = new Host(string2, n2);
        this.schemeName = string != null ? TextUtils.toLowerCase(string) : HttpHost.DEFAULT_SCHEME.id;
        this.address = inetAddress;
    }

    public HttpHost(String string, String string2, int n2) {
        this(string, null, string2, n2);
    }

    public HttpHost(String string, int n2) {
        this(null, string, n2);
    }

    public HttpHost(String string, String string2) {
        this(string, string2, -1);
    }

    public static HttpHost create(String object) throws URISyntaxException {
        Args.notEmpty(object, "HTTP Host");
        String string = object;
        String string2 = null;
        int n2 = string.indexOf("://");
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            if (TextUtils.containsBlanks(string2)) {
                throw new URISyntaxException((String)object, "scheme contains blanks");
            }
            string = string.substring(n2 + 3);
        }
        object = Host.create(string);
        return new HttpHost(string2, (NamedEndpoint)object);
    }

    public static HttpHost create(URI uRI) {
        String string = uRI.getScheme();
        return new HttpHost(string != null ? string : URIScheme.HTTP.getId(), uRI.getHost(), uRI.getPort());
    }

    public HttpHost(String string) {
        this(null, string, -1);
    }

    public HttpHost(String string, InetAddress inetAddress, int n2) {
        this(string, Args.notNull(inetAddress, "Inet address"), inetAddress.getHostName(), n2);
    }

    public HttpHost(InetAddress inetAddress, int n2) {
        this(null, inetAddress, n2);
    }

    public HttpHost(InetAddress inetAddress) {
        this(null, inetAddress, -1);
    }

    public HttpHost(String string, NamedEndpoint namedEndpoint) {
        this(string, Args.notNull(namedEndpoint, "Named endpoint").getHostName(), namedEndpoint.getPort());
    }

    @Deprecated
    public HttpHost(URIAuthority uRIAuthority) {
        this(null, uRIAuthority);
    }

    @Override
    public final String getHostName() {
        return this.host.getHostName();
    }

    @Override
    public final int getPort() {
        return this.host.getPort();
    }

    public final String getSchemeName() {
        return this.schemeName;
    }

    public final InetAddress getAddress() {
        return this.address;
    }

    public final String toURI() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.schemeName);
        stringBuilder.append("://");
        stringBuilder.append(this.host.toString());
        return stringBuilder.toString();
    }

    public final String toHostString() {
        return this.host.toString();
    }

    public final String toString() {
        return this.toURI();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HttpHost) {
            object = (HttpHost)object;
            return this.schemeName.equals(((HttpHost)object).schemeName) && this.host.equals(((HttpHost)object).host) && Objects.equals(this.address, ((HttpHost)object).address);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = LangUtils.hashCode(17, this.schemeName);
        n2 = LangUtils.hashCode(n2, this.host);
        n2 = LangUtils.hashCode(n2, this.address);
        return n2;
    }
}

