/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.ProtocolVersionParser$Factory;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

@Internal
public class ProtocolVersionParser {
    public static final ProtocolVersionParser INSTANCE = new ProtocolVersionParser();
    private static final char SLASH = '/';
    private static final char FULL_STOP = '.';
    private static final Tokenizer$Delimiter PROTO_DELIMITER = Tokenizer.delimiters('/');
    private static final Tokenizer$Delimiter FULL_STOP_OR_BLANK = Tokenizer.delimiters('.', ' ', '\t');
    private static final Tokenizer$Delimiter BLANK = Tokenizer.delimiters(' ', '\t');
    private final Tokenizer tokenizer = Tokenizer.INSTANCE;

    public ProtocolVersion parse(String string, ProtocolVersionParser$Factory protocolVersionParser$Factory, CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter object) throws ParseException {
        int n2;
        int n3;
        int n4 = tokenizer$Cursor.getLowerBound();
        int n5 = tokenizer$Cursor.getUpperBound();
        String string2 = this.tokenizer.parseToken(charSequence, tokenizer$Cursor, object != null ? arg_0 -> ProtocolVersionParser.lambda$parse$0((Tokenizer$Delimiter)object, arg_0) : FULL_STOP_OR_BLANK);
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid " + string + " major version number", charSequence, n4, n5, tokenizer$Cursor.getPos());
        }
        if (tokenizer$Cursor.atEnd()) {
            if (protocolVersionParser$Factory != null) {
                int n6 = n3;
                return protocolVersionParser$Factory.create(n6, n6);
            }
            return new ProtocolVersion(string, n3, 0);
        }
        if (charSequence.charAt(tokenizer$Cursor.getPos()) != '.') {
            if (protocolVersionParser$Factory != null) {
                int n7 = n3;
                return protocolVersionParser$Factory.create(n7, n7);
            }
            return new ProtocolVersion(string, n3, 0);
        }
        Tokenizer$Cursor tokenizer$Cursor2 = tokenizer$Cursor;
        tokenizer$Cursor2.updatePos(tokenizer$Cursor2.getPos() + 1);
        object = this.tokenizer.parseToken(charSequence, tokenizer$Cursor, object != null ? arg_0 -> ProtocolVersionParser.lambda$parse$1((Tokenizer$Delimiter)object, arg_0) : BLANK);
        try {
            n2 = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid " + string + " minor version number", charSequence, n4, n5, tokenizer$Cursor.getPos());
        }
        if (protocolVersionParser$Factory != null) {
            return protocolVersionParser$Factory.create(n3, n2);
        }
        return new ProtocolVersion(string, n3, n2);
    }

    public ProtocolVersion parse(String string, CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter tokenizer$Delimiter) throws ParseException {
        return this.parse(string, null, charSequence, tokenizer$Cursor, tokenizer$Delimiter);
    }

    public ProtocolVersion parse(String string, CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor) throws ParseException {
        return this.parse(string, null, charSequence, tokenizer$Cursor, null);
    }

    public ProtocolVersion parse(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter tokenizer$Delimiter) throws ParseException {
        this.tokenizer.skipWhiteSpace(charSequence, tokenizer$Cursor);
        String string = this.tokenizer.parseToken(charSequence, tokenizer$Cursor, PROTO_DELIMITER);
        if (TextUtils.isBlank(string)) {
            throw new ParseException("Invalid protocol name");
        }
        if (!tokenizer$Cursor.atEnd() && charSequence.charAt(tokenizer$Cursor.getPos()) == '/') {
            Tokenizer$Cursor tokenizer$Cursor2 = tokenizer$Cursor;
            tokenizer$Cursor2.updatePos(tokenizer$Cursor2.getPos() + 1);
            return this.parse(string, null, charSequence, tokenizer$Cursor, tokenizer$Delimiter);
        }
        throw new ParseException("Invalid protocol name");
    }

    private static /* synthetic */ boolean lambda$parse$1(Tokenizer$Delimiter tokenizer$Delimiter, char c2) {
        return tokenizer$Delimiter.test(c2) || BLANK.test(c2);
    }

    private static /* synthetic */ boolean lambda$parse$0(Tokenizer$Delimiter tokenizer$Delimiter, char c2) {
        return tokenizer$Delimiter.test(c2) || FULL_STOP_OR_BLANK.test(c2);
    }
}

