/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.config;

import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.config.CharCodingConfig$Builder;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class CharCodingConfig {
    public static final CharCodingConfig DEFAULT = new CharCodingConfig$Builder().build();
    private static final Charset DEFAULT_CHARSET = StandardCharsets.US_ASCII;
    private final Charset charset;
    private final CodingErrorAction malformedInputAction;
    private final CodingErrorAction unmappableInputAction;

    CharCodingConfig(Charset charset, CodingErrorAction codingErrorAction, CodingErrorAction codingErrorAction2) {
        this.charset = charset;
        this.malformedInputAction = codingErrorAction;
        this.unmappableInputAction = codingErrorAction2;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public CodingErrorAction getMalformedInputAction() {
        return this.malformedInputAction;
    }

    public CodingErrorAction getUnmappableInputAction() {
        return this.unmappableInputAction;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[charset=").append(this.charset).append(", malformedInputAction=").append(this.malformedInputAction).append(", unmappableInputAction=").append(this.unmappableInputAction).append("]");
        return stringBuilder.toString();
    }

    public static CharCodingConfig$Builder custom() {
        return new CharCodingConfig$Builder();
    }

    public static CharCodingConfig$Builder copy(CharCodingConfig charCodingConfig) {
        Args.notNull(charCodingConfig, "Config");
        return new CharCodingConfig$Builder().setCharset(charCodingConfig.getCharset()).setMalformedInputAction(charCodingConfig.getMalformedInputAction()).setUnmappableInputAction(charCodingConfig.getUnmappableInputAction());
    }

    static /* synthetic */ Charset access$000() {
        return DEFAULT_CHARSET;
    }
}

