/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.config;

import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public class Http1Config$Builder {
    private HttpVersion version = HttpVersion.HTTP_1_1;
    private int bufferSize = 8192;
    private int chunkSizeHint = -1;
    private Timeout waitForContinueTimeout = Http1Config.access$000();
    private int maxLineLength = -1;
    private int maxHeaderCount = -1;
    private int maxEmptyLineCount = 10;
    private int initialWindowSize = 65535;

    Http1Config$Builder() {
    }

    public Http1Config$Builder setVersion(HttpVersion httpVersion) {
        Args.notNull(httpVersion, "HTTP/1 protocol version");
        Args.check(httpVersion.getMajor() == 1, "HTTP/1 protocol version is required");
        this.version = httpVersion;
        return this;
    }

    public Http1Config$Builder setBufferSize(int n2) {
        this.bufferSize = n2;
        return this;
    }

    public Http1Config$Builder setChunkSizeHint(int n2) {
        this.chunkSizeHint = n2;
        return this;
    }

    public Http1Config$Builder setWaitForContinueTimeout(Timeout timeout) {
        this.waitForContinueTimeout = timeout;
        return this;
    }

    public Http1Config$Builder setMaxLineLength(int n2) {
        this.maxLineLength = n2;
        return this;
    }

    public Http1Config$Builder setMaxHeaderCount(int n2) {
        this.maxHeaderCount = n2;
        return this;
    }

    public Http1Config$Builder setMaxEmptyLineCount(int n2) {
        this.maxEmptyLineCount = n2;
        return this;
    }

    public Http1Config$Builder setInitialWindowSize(int n2) {
        Args.positive(n2, "Initial window size");
        this.initialWindowSize = n2;
        return this;
    }

    public Http1Config build() {
        return new Http1Config(this.version, this.bufferSize, this.chunkSizeHint, this.waitForContinueTimeout, this.maxLineLength, this.maxHeaderCount, this.maxEmptyLineCount, this.initialWindowSize);
    }
}

