/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.config;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.config.Http1Config$Builder;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class Http1Config {
    public static final Http1Config DEFAULT = new Http1Config$Builder().build();
    private final HttpVersion version;
    private final int bufferSize;
    private final int chunkSizeHint;
    private final Timeout waitForContinueTimeout;
    private final int maxLineLength;
    private final int maxHeaderCount;
    private final int maxEmptyLineCount;
    private final int initialWindowSize;
    private static final int INIT_WINDOW_SIZE = 65535;
    private static final int INIT_BUF_SIZE = 8192;
    private static final Timeout INIT_WAIT_FOR_CONTINUE = Timeout.ofSeconds(3L);
    private static final int INIT_BUF_CHUNK = -1;
    private static final int INIT_MAX_HEADER_COUNT = -1;
    private static final int INIT_MAX_LINE_LENGTH = -1;
    private static final int INIT_MAX_EMPTY_LINE_COUNT = 10;

    Http1Config(HttpVersion httpVersion, int n2, int n3, Timeout timeout, int n4, int n5, int n6, int n7) {
        this.version = httpVersion;
        this.bufferSize = n2;
        this.chunkSizeHint = n3;
        this.waitForContinueTimeout = timeout;
        this.maxLineLength = n4;
        this.maxHeaderCount = n5;
        this.maxEmptyLineCount = n6;
        this.initialWindowSize = n7;
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getChunkSizeHint() {
        return this.chunkSizeHint;
    }

    public Timeout getWaitForContinueTimeout() {
        return this.waitForContinueTimeout;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public int getMaxEmptyLineCount() {
        return this.maxEmptyLineCount;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[version=").append(this.version).append(", bufferSize=").append(this.bufferSize).append(", chunkSizeHint=").append(this.chunkSizeHint).append(", waitForContinueTimeout=").append(this.waitForContinueTimeout).append(", maxLineLength=").append(this.maxLineLength).append(", maxHeaderCount=").append(this.maxHeaderCount).append(", maxEmptyLineCount=").append(this.maxEmptyLineCount).append(", initialWindowSize=").append(this.initialWindowSize).append("]");
        return stringBuilder.toString();
    }

    public static Http1Config$Builder custom() {
        return new Http1Config$Builder();
    }

    public static Http1Config$Builder copy(Http1Config http1Config) {
        Args.notNull(http1Config, "Config");
        return new Http1Config$Builder().setVersion(http1Config.getVersion()).setBufferSize(http1Config.getBufferSize()).setChunkSizeHint(http1Config.getChunkSizeHint()).setWaitForContinueTimeout(http1Config.getWaitForContinueTimeout()).setMaxHeaderCount(http1Config.getMaxHeaderCount()).setMaxLineLength(http1Config.getMaxLineLength()).setMaxEmptyLineCount(http1Config.getMaxEmptyLineCount()).setInitialWindowSize(http1Config.getInitialWindowSize());
    }

    static /* synthetic */ Timeout access$000() {
        return INIT_WAIT_FOR_CONTINUE;
    }
}

