/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.net.InetSocketAddress;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;

public final class DefaultAddressResolver
implements Resolver<HttpHost, InetSocketAddress> {
    public static final DefaultAddressResolver INSTANCE = new DefaultAddressResolver();

    @Override
    public final InetSocketAddress resolve(HttpHost httpHost) {
        if (httpHost == null) {
            return null;
        }
        int n2 = httpHost.getPort();
        if (n2 < 0) {
            String string = httpHost.getSchemeName();
            if (URIScheme.HTTP.same(string)) {
                n2 = 80;
            } else if (URIScheme.HTTPS.same(string)) {
                n2 = 443;
            }
        }
        if (httpHost.getAddress() != null) {
            return new InetSocketAddress(httpHost.getAddress(), n2);
        }
        return new InetSocketAddress(httpHost.getHostName(), n2);
    }
}

