/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.NotImplementedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy$Coding;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultContentLengthStrategy
implements ContentLengthStrategy {
    public static final DefaultContentLengthStrategy INSTANCE = new DefaultContentLengthStrategy();

    @Override
    public long determineLength(HttpMessage object) throws HttpException {
        Args.notNull(object, "HTTP message");
        Header header = object.getFirstHeader("Transfer-Encoding");
        if (header != null) {
            AtomicReference atomicReference = new AtomicReference();
            MessageSupport.parseTokens((MessageHeaders)object, "Transfer-Encoding", string -> {
                if (!(TextUtils.isBlank(string) || string.equalsIgnoreCase("chunked") && atomicReference.compareAndSet(null, DefaultContentLengthStrategy$Coding.CHUNK))) {
                    atomicReference.set(DefaultContentLengthStrategy$Coding.UNKNOWN);
                }
            });
            if (atomicReference.get() == DefaultContentLengthStrategy$Coding.CHUNK) {
                return -1L;
            }
            throw new NotImplementedException("Unsupported transfer encoding: " + header.getValue());
        }
        if (object.countHeaders("Content-Length") > 1) {
            throw new ProtocolException("Multiple Content-Length headers");
        }
        Header header2 = object.getFirstHeader("Content-Length");
        if (header2 != null) {
            object = header2.getValue();
            try {
                long l2 = Long.parseLong((String)object);
                if (l2 < 0L) {
                    throw new ProtocolException("Negative content length: " + (String)object);
                }
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException("Invalid content length: " + (String)object);
            }
        }
        return -9223372036854775807L;
    }
}

