/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.util.Collections;
import java.util.Set;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.Args;

@Internal
public class IncomingEntityDetails
implements EntityDetails {
    private final MessageHeaders message;
    private final long contentLength;

    public IncomingEntityDetails(MessageHeaders messageHeaders, long l2) {
        this.message = Args.notNull(messageHeaders, "Message");
        this.contentLength = l2;
    }

    public IncomingEntityDetails(MessageHeaders messageHeaders) {
        this(messageHeaders, -1L);
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        Header header = this.message.getFirstHeader("Content-Type");
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public String getContentEncoding() {
        Header header = this.message.getFirstHeader("Content-Encoding");
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public boolean isChunked() {
        return this.contentLength < 0L;
    }

    @Override
    public Set<String> getTrailerNames() {
        Header header = this.message.getFirstHeader("Trailer");
        if (header == null) {
            return Collections.emptySet();
        }
        return MessageSupport.parseTokens(header);
    }
}

