/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.impl.bootstrap.AbstractConnectionInitiatorBase;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorService;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class AsyncRequester
extends AbstractConnectionInitiatorBase
implements IOReactorService {
    private final DefaultConnectingIOReactor ioReactor;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;

    @Internal
    public AsyncRequester(IOEventHandlerFactory iOEventHandlerFactory, IOReactorConfig iOReactorConfig, Decorator<IOSession> decorator, Callback<Exception> callback, IOSessionListener iOSessionListener, Callback<IOSession> callback2, Resolver<HttpHost, InetSocketAddress> defaultAddressResolver) {
        this.ioReactor = new DefaultConnectingIOReactor(iOEventHandlerFactory, iOReactorConfig, new DefaultThreadFactory("requester-dispatch", true), decorator, callback, iOSessionListener, callback2);
        this.addressResolver = defaultAddressResolver != null ? defaultAddressResolver : DefaultAddressResolver.INSTANCE;
    }

    @Override
    ConnectionInitiator getIOReactor() {
        return this.ioReactor;
    }

    public Future<IOSession> requestSession(HttpHost httpHost, Timeout timeout, Object object, FutureCallback<IOSession> futureCallback) {
        Args.notNull(httpHost, "Host");
        Args.notNull(timeout, "Timeout");
        return this.connect(httpHost, this.addressResolver.resolve(httpHost), null, timeout, object, futureCallback);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue timeValue) throws InterruptedException {
        this.ioReactor.awaitShutdown(timeValue);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }

    @Internal
    protected static HttpHost defaultTarget(HttpRequest object) throws ProtocolException {
        String string = object.getScheme();
        if ((object = object.getAuthority()) == null) {
            throw new ProtocolException("Request authority not specified");
        }
        return new HttpHost(string, (NamedEndpoint)object);
    }
}

