/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.nio.ssl.TlsUpgradeCapable;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;

class HttpAsyncRequester$InternalAsyncClientEndpoint
extends AsyncClientEndpoint
implements TlsUpgradeCapable {
    final AtomicReference<PoolEntry<HttpHost, IOSession>> poolEntryRef;
    final /* synthetic */ HttpAsyncRequester this$0;

    HttpAsyncRequester$InternalAsyncClientEndpoint(HttpAsyncRequester httpAsyncRequester, PoolEntry<HttpHost, IOSession> poolEntry) {
        this.this$0 = httpAsyncRequester;
        this.poolEntryRef = new AtomicReference<PoolEntry<HttpHost, IOSession>>(poolEntry);
    }

    private IOSession getIOSession() {
        PoolEntry<HttpHost, IOSession> poolEntry = this.poolEntryRef.get();
        if (poolEntry == null) {
            throw new IllegalStateException("Endpoint has already been released");
        }
        if ((poolEntry = poolEntry.getConnection()) == null) {
            throw new IllegalStateException("I/O session is invalid");
        }
        return poolEntry;
    }

    @Override
    public void execute(AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpContext httpContext) {
        IOSession iOSession = this.getIOSession();
        iOSession.enqueue(new RequestExecutionCommand(asyncClientExchangeHandler, handlerFactory, null, httpContext), Command$Priority.NORMAL);
        if (!iOSession.isOpen()) {
            try {
                asyncClientExchangeHandler.failed(new ConnectionClosedException());
                return;
            }
            finally {
                asyncClientExchangeHandler.releaseResources();
            }
        }
    }

    @Override
    public boolean isConnected() {
        PoolEntry<HttpHost, IOSession> poolEntry = this.poolEntryRef.get();
        if (poolEntry != null) {
            if ((poolEntry = poolEntry.getConnection()) == null || !poolEntry.isOpen()) {
                return false;
            }
            return (poolEntry = poolEntry.getHandler()) instanceof HttpConnection && ((HttpConnection)((Object)poolEntry)).isOpen();
        }
        return false;
    }

    @Override
    public void releaseAndReuse() {
        PoolEntry poolEntry = this.poolEntryRef.getAndSet(null);
        if (poolEntry != null) {
            IOSession iOSession = (IOSession)poolEntry.getConnection();
            HttpAsyncRequester.access$000(this.this$0).release(poolEntry, iOSession != null && iOSession.isOpen());
        }
    }

    @Override
    public void releaseAndDiscard() {
        PoolEntry poolEntry = this.poolEntryRef.getAndSet(null);
        if (poolEntry != null) {
            poolEntry.discardConnection(CloseMode.GRACEFUL);
            HttpAsyncRequester.access$000(this.this$0).release(poolEntry, false);
        }
    }

    @Override
    public void tlsUpgrade(NamedEndpoint namedEndpoint, FutureCallback<ProtocolIOSession> futureCallback) {
        IOSession iOSession = this.getIOSession();
        if (iOSession instanceof ProtocolIOSession) {
            this.this$0.doTlsUpgrade((ProtocolIOSession)iOSession, namedEndpoint, futureCallback);
            return;
        }
        throw new IllegalStateException("TLS upgrade not supported");
    }
}

