/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.impl.bootstrap.AsyncRequester;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester$1;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester$2;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester$3;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester$4;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpAsyncRequester
extends AsyncRequester
implements ConnPoolControl<HttpHost> {
    private final ManagedConnPool<HttpHost, IOSession> connPool;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    @Internal
    public HttpAsyncRequester(IOReactorConfig iOReactorConfig, IOEventHandlerFactory iOEventHandlerFactory, Decorator<IOSession> decorator, Callback<Exception> callback, IOSessionListener iOSessionListener, ManagedConnPool<HttpHost, IOSession> managedConnPool, TlsStrategy tlsStrategy, Timeout timeout) {
        super(iOEventHandlerFactory, iOReactorConfig, decorator, callback, iOSessionListener, ShutdownCommand.GRACEFUL_IMMEDIATE_CALLBACK, DefaultAddressResolver.INSTANCE);
        this.connPool = Args.notNull(managedConnPool, "Connection pool");
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = timeout;
    }

    @Internal
    public HttpAsyncRequester(IOReactorConfig iOReactorConfig, IOEventHandlerFactory iOEventHandlerFactory, Decorator<IOSession> decorator, Callback<Exception> callback, IOSessionListener iOSessionListener, ManagedConnPool<HttpHost, IOSession> managedConnPool) {
        this(iOReactorConfig, iOEventHandlerFactory, decorator, callback, iOSessionListener, managedConnPool, null, null);
    }

    @Override
    public PoolStats getTotalStats() {
        return this.connPool.getTotalStats();
    }

    @Override
    public PoolStats getStats(HttpHost httpHost) {
        return this.connPool.getStats(httpHost);
    }

    @Override
    public void setMaxTotal(int n2) {
        this.connPool.setMaxTotal(n2);
    }

    @Override
    public int getMaxTotal() {
        return this.connPool.getMaxTotal();
    }

    @Override
    public void setDefaultMaxPerRoute(int n2) {
        this.connPool.setDefaultMaxPerRoute(n2);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.connPool.getDefaultMaxPerRoute();
    }

    @Override
    public void setMaxPerRoute(HttpHost httpHost, int n2) {
        this.connPool.setMaxPerRoute(httpHost, n2);
    }

    @Override
    public int getMaxPerRoute(HttpHost httpHost) {
        return this.connPool.getMaxPerRoute(httpHost);
    }

    @Override
    public void closeIdle(TimeValue timeValue) {
        this.connPool.closeIdle(timeValue);
    }

    @Override
    public void closeExpired() {
        this.connPool.closeExpired();
    }

    @Override
    public Set<HttpHost> getRoutes() {
        return this.connPool.getRoutes();
    }

    public Future<AsyncClientEndpoint> connect(HttpHost httpHost, Timeout timeout, Object object, FutureCallback<AsyncClientEndpoint> futureCallback) {
        return this.doConnect(httpHost, timeout, object, futureCallback);
    }

    protected Future<AsyncClientEndpoint> doConnect(HttpHost object, Timeout timeout, Object object2, FutureCallback<AsyncClientEndpoint> object3) {
        Args.notNull(object, "Host");
        Args.notNull(timeout, "Timeout");
        object3 = new ComplexFuture<AsyncClientEndpoint>((FutureCallback<AsyncClientEndpoint>)object3);
        object = this.connPool.lease((HttpHost)object, null, timeout, new HttpAsyncRequester$1(this, (ComplexFuture)object3, (HttpHost)object, timeout, object2));
        ((ComplexFuture)object3).setDependency((Future<?>)object);
        return object3;
    }

    public Future<AsyncClientEndpoint> connect(HttpHost httpHost, Timeout timeout) {
        return this.connect(httpHost, timeout, null, null);
    }

    public void execute(HttpHost httpHost, AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, Timeout timeout, HttpContext httpContext) {
        Args.notNull(asyncClientExchangeHandler, "Exchange handler");
        Args.notNull(timeout, "Timeout");
        Args.notNull(httpContext, "Context");
        try {
            asyncClientExchangeHandler.produceRequest((httpRequest, entityDetails, httpContext2) -> {
                HttpHost httpHost2 = httpHost = httpHost != null ? httpHost : HttpAsyncRequester.defaultTarget(httpRequest);
                if (httpRequest.getAuthority() == null) {
                    httpRequest.setAuthority(new URIAuthority(httpHost.getHostName(), httpHost.getPort()));
                }
                this.connect(httpHost, timeout, null, new HttpAsyncRequester$2(this, asyncClientExchangeHandler, httpRequest, entityDetails, handlerFactory, httpContext));
            }, httpContext);
            return;
        }
        catch (IOException | HttpException exception) {
            asyncClientExchangeHandler.failed(exception);
            return;
        }
    }

    public void execute(AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, Timeout timeout, HttpContext httpContext) {
        this.execute(null, asyncClientExchangeHandler, handlerFactory, timeout, httpContext);
    }

    public void execute(AsyncClientExchangeHandler asyncClientExchangeHandler, Timeout timeout, HttpContext httpContext) {
        this.execute(asyncClientExchangeHandler, null, timeout, httpContext);
    }

    public final <T> Future<T> execute(HttpHost httpHost, AsyncRequestProducer asyncDataProducer, AsyncResponseConsumer<T> asyncResponseConsumer, HandlerFactory<AsyncPushConsumer> handlerFactory, Timeout timeout, HttpContext httpContext, FutureCallback<T> object) {
        Args.notNull(asyncDataProducer, "Request producer");
        Args.notNull(asyncResponseConsumer, "Response consumer");
        Args.notNull(timeout, "Timeout");
        Object object2 = object = new BasicFuture<T>(object);
        asyncDataProducer = new BasicClientExchangeHandler<T>((AsyncRequestProducer)asyncDataProducer, asyncResponseConsumer, new HttpAsyncRequester$3(this, (BasicFuture)object2, (BasicFuture)object2));
        this.execute(httpHost, (AsyncClientExchangeHandler)asyncDataProducer, handlerFactory, timeout, httpContext != null ? httpContext : HttpCoreContext.create());
        return object;
    }

    public final <T> Future<T> execute(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, HandlerFactory<AsyncPushConsumer> handlerFactory, Timeout timeout, HttpContext httpContext, FutureCallback<T> futureCallback) {
        return this.execute(null, asyncRequestProducer, asyncResponseConsumer, handlerFactory, timeout, httpContext, futureCallback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, Timeout timeout, HttpContext httpContext, FutureCallback<T> futureCallback) {
        return this.execute(asyncRequestProducer, asyncResponseConsumer, null, timeout, httpContext, futureCallback);
    }

    public final <T> Future<T> execute(HttpHost httpHost, AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, Timeout timeout, FutureCallback<T> futureCallback) {
        return this.execute(httpHost, asyncRequestProducer, asyncResponseConsumer, null, timeout, null, futureCallback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, Timeout timeout, FutureCallback<T> futureCallback) {
        return this.execute(asyncRequestProducer, asyncResponseConsumer, null, timeout, null, futureCallback);
    }

    protected void doTlsUpgrade(ProtocolIOSession protocolIOSession, NamedEndpoint namedEndpoint, FutureCallback<ProtocolIOSession> futureCallback) {
        if (this.tlsStrategy != null) {
            FutureCallback<ProtocolIOSession> futureCallback2 = futureCallback;
            this.tlsStrategy.upgrade(protocolIOSession, namedEndpoint, null, this.handshakeTimeout, new HttpAsyncRequester$4(this, futureCallback2, futureCallback2, protocolIOSession));
            return;
        }
        throw new IllegalStateException("TLS upgrade not supported");
    }

    static /* synthetic */ ManagedConnPool access$000(HttpAsyncRequester httpAsyncRequester) {
        return httpAsyncRequester.connPool;
    }
}

