/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer$Status;
import org.apache.hc.core5.http.impl.bootstrap.RequestListener;
import org.apache.hc.core5.http.impl.bootstrap.Worker;
import org.apache.hc.core5.http.impl.bootstrap.WorkerPoolExecutor;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnection;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnectionFactory;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.io.SocketSupport;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpServer
implements ModalCloseable {
    private final int port;
    private final InetAddress ifAddress;
    private final SocketConfig socketConfig;
    private final ServerSocketFactory serverSocketFactory;
    private final HttpService httpService;
    private final HttpConnectionFactory<? extends DefaultBHttpServerConnection> connectionFactory;
    private final SSLContext sslContext;
    private final Callback<SSLParameters> sslSetupHandler;
    private final ExceptionListener exceptionListener;
    private final ThreadPoolExecutor listenerExecutorService;
    private final ThreadGroup workerThreads;
    private final WorkerPoolExecutor workerExecutorService;
    private final AtomicReference<HttpServer$Status> status;
    private volatile ServerSocket serverSocket;
    private volatile RequestListener requestListener;

    @Internal
    public HttpServer(int n2, HttpService httpService, InetAddress inetAddress, SocketConfig socketConfig, ServerSocketFactory serverSocketFactory, HttpConnectionFactory<? extends DefaultBHttpServerConnection> defaultBHttpServerConnectionFactory, SSLContext sSLContext, Callback<SSLParameters> callback, ExceptionListener exceptionListener) {
        this.port = Args.notNegative(n2, "Port value is negative");
        this.httpService = Args.notNull(httpService, "HTTP service");
        this.ifAddress = inetAddress;
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        ServerSocketFactory serverSocketFactory2 = this.serverSocketFactory = serverSocketFactory != null ? serverSocketFactory : ServerSocketFactory.getDefault();
        this.connectionFactory = defaultBHttpServerConnectionFactory != null ? defaultBHttpServerConnectionFactory : new DefaultBHttpServerConnectionFactory(this.serverSocketFactory instanceof SSLServerSocketFactory ? URIScheme.HTTPS.id : URIScheme.HTTP.id, Http1Config.DEFAULT, CharCodingConfig.DEFAULT);
        this.sslContext = sSLContext;
        this.sslSetupHandler = callback;
        this.exceptionListener = exceptionListener != null ? exceptionListener : ExceptionListener.NO_OP;
        this.listenerExecutorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory("HTTP-listener-" + this.port));
        this.workerThreads = new ThreadGroup("HTTP-workers");
        this.workerExecutorService = new WorkerPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory("HTTP-worker", this.workerThreads, true));
        this.status = new AtomicReference<HttpServer$Status>(HttpServer$Status.READY);
    }

    public InetAddress getInetAddress() {
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket != null) {
            return serverSocket.getInetAddress();
        }
        return null;
    }

    public int getLocalPort() {
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket != null) {
            return serverSocket.getLocalPort();
        }
        return -1;
    }

    public void start() throws IOException {
        if (this.status.compareAndSet(HttpServer$Status.READY, HttpServer$Status.ACTIVE)) {
            this.serverSocket = this.serverSocketFactory.createServerSocket(this.port, this.socketConfig.getBacklogSize(), this.ifAddress);
            this.serverSocket.setReuseAddress(this.socketConfig.isSoReuseAddress());
            if (this.socketConfig.getRcvBufSize() > 0) {
                this.serverSocket.setReceiveBufferSize(this.socketConfig.getRcvBufSize());
            }
            if (this.socketConfig.getTcpKeepIdle() > 0) {
                SocketSupport.setOption(this.serverSocket, "TCP_KEEPIDLE", this.socketConfig.getTcpKeepIdle());
            }
            if (this.socketConfig.getTcpKeepInterval() > 0) {
                SocketSupport.setOption(this.serverSocket, "TCP_KEEPINTERVAL", this.socketConfig.getTcpKeepInterval());
            }
            if (this.socketConfig.getTcpKeepCount() > 0) {
                SocketSupport.setOption(this.serverSocket, "TCP_KEEPCOUNT", this.socketConfig.getTcpKeepCount());
            }
            if (this.sslSetupHandler != null && this.serverSocket instanceof SSLServerSocket) {
                SSLServerSocket sSLServerSocket = (SSLServerSocket)this.serverSocket;
                SSLParameters sSLParameters = sSLServerSocket.getSSLParameters();
                this.sslSetupHandler.execute(sSLParameters);
                sSLServerSocket.setSSLParameters(sSLParameters);
            }
            this.requestListener = new RequestListener(this.socketConfig, this.serverSocket, this.httpService, this.connectionFactory, this.sslContext != null ? this.sslContext.getSocketFactory() : null, this.sslSetupHandler, this.exceptionListener, this.workerExecutorService);
            this.listenerExecutorService.execute(this.requestListener);
        }
    }

    public void stop() {
        if (this.status.compareAndSet(HttpServer$Status.ACTIVE, HttpServer$Status.STOPPING)) {
            this.listenerExecutorService.shutdownNow();
            this.workerExecutorService.shutdown();
            RequestListener requestListener = this.requestListener;
            if (requestListener != null) {
                try {
                    requestListener.terminate();
                }
                catch (IOException iOException) {
                    this.exceptionListener.onError(iOException);
                }
            }
            this.workerThreads.interrupt();
        }
    }

    public void initiateShutdown() {
        this.stop();
    }

    public void awaitTermination(TimeValue timeValue) throws InterruptedException {
        Args.notNull(timeValue, "Wait time");
        this.workerExecutorService.awaitTermination(timeValue.getDuration(), timeValue.getTimeUnit());
    }

    @Override
    public void close(CloseMode closeMode) {
        this.close(closeMode, Timeout.ofSeconds(5L));
    }

    public void close(CloseMode object, Timeout object2) {
        this.initiateShutdown();
        if (object == CloseMode.GRACEFUL) {
            try {
                this.awaitTermination((TimeValue)object2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        object = this.workerExecutorService.getWorkers();
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Worker)object.next();
            Closer.close(((Worker)object2).getConnection(), CloseMode.GRACEFUL);
        }
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }
}

