/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.NamedElementChain;
import org.apache.hc.core5.http.config.NamedElementChain$Node;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.FilterEntry;
import org.apache.hc.core5.http.impl.bootstrap.FilterEntry$Position;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnection;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnectionFactory;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.impl.routing.RequestRouter$Entry;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpFilterHandler;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.ssl.DefaultTlsSetupHandler;
import org.apache.hc.core5.http.io.support.BasicHttpServerExpectationDecorator;
import org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.apache.hc.core5.http.io.support.HttpServerExpectationFilter;
import org.apache.hc.core5.http.io.support.HttpServerFilterChainElement;
import org.apache.hc.core5.http.io.support.HttpServerFilterChainRequestHandler;
import org.apache.hc.core5.http.io.support.TerminalServerFilter;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.LookupRegistry;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http.protocol.UriPatternMatcher;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

public class ServerBootstrap {
    private final List<RequestRouter$Entry<HttpRequestHandler>> routeEntries = new ArrayList<RequestRouter$Entry<HttpRequestHandler>>();
    private final List<FilterEntry<HttpFilterHandler>> filters = new ArrayList<FilterEntry<HttpFilterHandler>>();
    private String canonicalHostName;
    private HttpRequestMapper<HttpRequestHandler> requestRouter;
    private LookupRegistry<HttpRequestHandler> lookupRegistry;
    private int listenerPort;
    private InetAddress localAddress;
    private SocketConfig socketConfig;
    private Http1Config http1Config;
    private CharCodingConfig charCodingConfig;
    private HttpProcessor httpProcessor;
    private ConnectionReuseStrategy connStrategy;
    private HttpResponseFactory<ClassicHttpResponse> responseFactory;
    private ServerSocketFactory serverSocketFactory;
    private SSLContext sslContext;
    private Callback<SSLParameters> sslSetupHandler;
    private HttpConnectionFactory<? extends DefaultBHttpServerConnection> connectionFactory;
    private ExceptionListener exceptionListener;
    private Http1StreamListener streamListener;

    private ServerBootstrap() {
    }

    public static ServerBootstrap bootstrap() {
        return new ServerBootstrap();
    }

    public final ServerBootstrap setCanonicalHostName(String string) {
        this.canonicalHostName = string;
        return this;
    }

    public final ServerBootstrap setListenerPort(int n2) {
        this.listenerPort = n2;
        return this;
    }

    public final ServerBootstrap setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
        return this;
    }

    public final ServerBootstrap setSocketConfig(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
        return this;
    }

    public final ServerBootstrap setHttp1Config(Http1Config http1Config) {
        this.http1Config = http1Config;
        return this;
    }

    public final ServerBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final ServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final ServerBootstrap setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.connStrategy = connectionReuseStrategy;
        return this;
    }

    public final ServerBootstrap setResponseFactory(HttpResponseFactory<ClassicHttpResponse> httpResponseFactory) {
        this.responseFactory = httpResponseFactory;
        return this;
    }

    @Deprecated
    public final ServerBootstrap setLookupRegistry(LookupRegistry<HttpRequestHandler> lookupRegistry) {
        this.lookupRegistry = lookupRegistry;
        return this;
    }

    public final ServerBootstrap register(String string, HttpRequestHandler httpRequestHandler) {
        Args.notBlank(string, "URI pattern");
        Args.notNull(httpRequestHandler, "Supplier");
        this.routeEntries.add(new RequestRouter$Entry<HttpRequestHandler>(string, httpRequestHandler));
        return this;
    }

    public final ServerBootstrap register(String string, String string2, HttpRequestHandler httpRequestHandler) {
        Args.notBlank(string, "Hostname");
        Args.notBlank(string2, "URI pattern");
        Args.notNull(httpRequestHandler, "Request handler");
        this.routeEntries.add(new RequestRouter$Entry<HttpRequestHandler>(string, string2, httpRequestHandler));
        return this;
    }

    @Deprecated
    public final ServerBootstrap registerVirtual(String string, String string2, HttpRequestHandler httpRequestHandler) {
        return this.register(string, string2, httpRequestHandler);
    }

    public final ServerBootstrap setRequestRouter(HttpRequestMapper<HttpRequestHandler> httpRequestMapper) {
        this.requestRouter = httpRequestMapper;
        return this;
    }

    public final ServerBootstrap setConnectionFactory(HttpConnectionFactory<? extends DefaultBHttpServerConnection> httpConnectionFactory) {
        this.connectionFactory = httpConnectionFactory;
        return this;
    }

    public final ServerBootstrap setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
        return this;
    }

    public final ServerBootstrap setSslContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
        return this;
    }

    public final ServerBootstrap setSslSetupHandler(Callback<SSLParameters> callback) {
        this.sslSetupHandler = callback;
        return this;
    }

    public final ServerBootstrap setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
        return this;
    }

    public final ServerBootstrap setStreamListener(Http1StreamListener http1StreamListener) {
        this.streamListener = http1StreamListener;
        return this;
    }

    public final ServerBootstrap addFilterBefore(String string, String string2, HttpFilterHandler httpFilterHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(httpFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry$Position.BEFORE, string2, httpFilterHandler, string));
        return this;
    }

    public final ServerBootstrap addFilterAfter(String string, String string2, HttpFilterHandler httpFilterHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(httpFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry$Position.AFTER, string2, httpFilterHandler, string));
        return this;
    }

    public final ServerBootstrap replaceFilter(String string, HttpFilterHandler httpFilterHandler) {
        Args.notBlank(string, "Existing");
        Args.notNull(httpFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry$Position.REPLACE, string, httpFilterHandler, string));
        return this;
    }

    public final ServerBootstrap addFilterFirst(String string, HttpFilterHandler httpFilterHandler) {
        Args.notNull(string, "Name");
        Args.notNull(httpFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry$Position.FIRST, string, httpFilterHandler, null));
        return this;
    }

    public final ServerBootstrap addFilterLast(String string, HttpFilterHandler httpFilterHandler) {
        Args.notNull(string, "Name");
        Args.notNull(httpFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry$Position.LAST, string, httpFilterHandler, null));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServer create() {
        void var3_11;
        Object object;
        HttpRequestMapper<HttpRequestHandler> httpRequestMapper3;
        HttpRequestMapper<HttpRequestHandler> httpRequestMapper2 = httpRequestMapper3 = this.canonicalHostName != null ? this.canonicalHostName : InetAddressUtils.getCanonicalLocalHostName();
        if (this.lookupRegistry != null && this.requestRouter == null) {
            httpRequestMapper3 = new RequestHandlerRegistry((String)((Object)httpRequestMapper3), () -> {
                if (this.lookupRegistry != null) {
                    return this.lookupRegistry;
                }
                return new UriPatternMatcher();
            });
            for (RequestRouter$Entry object22 : this.routeEntries) {
                ((RequestHandlerRegistry)httpRequestMapper3).register(object22.uriAuthority != null ? object22.uriAuthority.getHostName() : null, (String)object22.route.pattern, (HttpRequestHandler)object22.route.handler);
            }
        } else {
            httpRequestMapper3 = this.routeEntries.isEmpty() ? this.requestRouter : RequestRouter.create(new URIAuthority((String)((Object)httpRequestMapper3)), UriPatternType.URI_PATTERN, this.routeEntries, RequestRouter.IGNORE_PORT_AUTHORITY_RESOLVER, this.requestRouter);
        }
        if (!this.filters.isEmpty()) {
            void var3_6;
            object = new NamedElementChain<TerminalServerFilter>();
            ((NamedElementChain)object).addLast(new TerminalServerFilter(httpRequestMapper3, this.responseFactory != null ? this.responseFactory : DefaultClassicHttpResponseFactory.INSTANCE), StandardFilter.MAIN_HANDLER.name());
            ((NamedElementChain)object).addFirst(new HttpServerExpectationFilter(), StandardFilter.EXPECT_CONTINUE.name());
            for (HttpRequestMapper<HttpRequestHandler> httpRequestMapper3 : this.filters) {
                switch (((FilterEntry)((Object)httpRequestMapper3)).position) {
                    case AFTER: {
                        ((NamedElementChain)object).addAfter(((FilterEntry)((Object)httpRequestMapper3)).existing, ((FilterEntry)((Object)httpRequestMapper3)).filterHandler, ((FilterEntry)((Object)httpRequestMapper3)).name);
                        break;
                    }
                    case BEFORE: {
                        ((NamedElementChain)object).addBefore(((FilterEntry)((Object)httpRequestMapper3)).existing, ((FilterEntry)((Object)httpRequestMapper3)).filterHandler, ((FilterEntry)((Object)httpRequestMapper3)).name);
                        break;
                    }
                    case REPLACE: {
                        ((NamedElementChain)object).replace(((FilterEntry)((Object)httpRequestMapper3)).existing, ((FilterEntry)((Object)httpRequestMapper3)).filterHandler);
                        break;
                    }
                    case FIRST: {
                        ((NamedElementChain)object).addFirst(((FilterEntry)((Object)httpRequestMapper3)).filterHandler, ((FilterEntry)((Object)httpRequestMapper3)).name);
                        break;
                    }
                    case LAST: {
                        ((NamedElementChain)object).addBefore(StandardFilter.MAIN_HANDLER.name(), ((FilterEntry)((Object)httpRequestMapper3)).filterHandler, ((FilterEntry)((Object)httpRequestMapper3)).name);
                    }
                }
            }
            NamedElementChain$Node namedElementChain$Node = ((NamedElementChain)object).getLast();
            httpRequestMapper3 = null;
            while (var3_6 != null) {
                httpRequestMapper3 = new HttpServerFilterChainElement((HttpFilterHandler)var3_6.getValue(), (HttpServerFilterChainElement)((Object)httpRequestMapper3));
                NamedElementChain$Node namedElementChain$Node2 = var3_6.getPrevious();
            }
            httpRequestMapper3 = new HttpServerFilterChainRequestHandler((HttpServerFilterChainElement)((Object)httpRequestMapper3));
        } else {
            httpRequestMapper3 = new BasicHttpServerExpectationDecorator(new BasicHttpServerRequestHandler(httpRequestMapper3, this.responseFactory != null ? this.responseFactory : DefaultClassicHttpResponseFactory.INSTANCE));
        }
        object = new HttpService(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), (HttpServerRequestHandler)((Object)httpRequestMapper3), this.http1Config, this.connStrategy != null ? this.connStrategy : DefaultConnectionReuseStrategy.INSTANCE, this.streamListener);
        HttpConnectionFactory<? extends DefaultBHttpServerConnection> httpConnectionFactory = this.connectionFactory;
        if (httpConnectionFactory == null) {
            httpRequestMapper3 = this.serverSocketFactory instanceof SSLServerSocketFactory || this.sslContext != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id;
            DefaultBHttpServerConnectionFactory defaultBHttpServerConnectionFactory = new DefaultBHttpServerConnectionFactory((String)((Object)httpRequestMapper3), this.http1Config, this.charCodingConfig);
        }
        return new HttpServer(Math.max(this.listenerPort, 0), (HttpService)object, this.localAddress, this.socketConfig != null ? this.socketConfig : SocketConfig.DEFAULT, this.serverSocketFactory, (HttpConnectionFactory<? extends DefaultBHttpServerConnection>)var3_11, this.sslContext, this.sslSetupHandler != null ? this.sslSetupHandler : DefaultTlsSetupHandler.SERVER, this.exceptionListener != null ? this.exceptionListener : ExceptionListener.NO_OP);
    }
}

