/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.impl.bootstrap.Worker;

class WorkerPoolExecutor
extends ThreadPoolExecutor {
    private final Map<Worker, Boolean> workerSet = new ConcurrentHashMap<Worker, Boolean>();

    public WorkerPoolExecutor(int n2, int n3, long l2, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        super(n2, n3, l2, timeUnit, blockingQueue, threadFactory);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        if (runnable instanceof Worker) {
            this.workerSet.put((Worker)runnable, Boolean.TRUE);
        }
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        if (runnable instanceof Worker) {
            this.workerSet.remove(runnable);
        }
    }

    public Set<Worker> getWorkers() {
        return new HashSet<Worker>(this.workerSet.keySet());
    }
}

