/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.MalformedChunkCodingException;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.TruncatedChunkException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import org.apache.hc.core5.http.impl.io.ChunkedInputStream$State;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public class ChunkedInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 2048;
    private static final Header[] EMPTY_FOOTERS = new Header[0];
    private final SessionInputBuffer buffer;
    private final InputStream inputStream;
    private final CharArrayBuffer lineBuffer;
    private final Http1Config http1Config;
    private ChunkedInputStream$State state;
    private long chunkSize;
    private long pos;
    private boolean eof;
    private boolean closed;
    private Header[] footers = EMPTY_FOOTERS;

    public ChunkedInputStream(SessionInputBuffer sessionInputBuffer, InputStream inputStream, Http1Config http1Config) {
        this.buffer = Args.notNull(sessionInputBuffer, "Session input buffer");
        this.inputStream = Args.notNull(inputStream, "Input stream");
        this.pos = 0L;
        this.lineBuffer = new CharArrayBuffer(16);
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.state = ChunkedInputStream$State.CHUNK_LEN;
    }

    public ChunkedInputStream(SessionInputBuffer sessionInputBuffer, InputStream inputStream) {
        this(sessionInputBuffer, inputStream, null);
    }

    @Override
    public int available() throws IOException {
        int n2 = this.buffer.length();
        return (int)Math.min((long)n2, this.chunkSize - this.pos);
    }

    @Override
    public int read() throws IOException {
        int n2;
        if (this.closed) {
            throw new StreamClosedException();
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != ChunkedInputStream$State.CHUNK_DATA) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((n2 = this.buffer.read(this.inputStream)) != -1) {
            ++this.pos;
            if (this.pos >= this.chunkSize) {
                this.state = ChunkedInputStream$State.CHUNK_CRLF;
            }
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new StreamClosedException();
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != ChunkedInputStream$State.CHUNK_DATA) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((n4 = this.buffer.read(byArray, n2, (int)Math.min((long)n3, this.chunkSize - this.pos), this.inputStream)) != -1) {
            this.pos += (long)n4;
            if (this.pos >= this.chunkSize) {
                this.state = ChunkedInputStream$State.CHUNK_CRLF;
            }
            return n4;
        }
        this.eof = true;
        throw new TruncatedChunkException("Truncated chunk (expected size: %d; actual size: %d)", this.chunkSize, this.pos);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private void nextChunk() throws IOException {
        if (this.state == ChunkedInputStream$State.CHUNK_INVALID) {
            throw new MalformedChunkCodingException("Corrupt data stream");
        }
        try {
            this.chunkSize = this.getChunkSize();
            if (this.chunkSize < 0L) {
                throw new MalformedChunkCodingException("Negative chunk size");
            }
            this.state = ChunkedInputStream$State.CHUNK_DATA;
            this.pos = 0L;
            if (this.chunkSize == 0L) {
                this.eof = true;
                this.parseTrailerHeaders();
            }
            return;
        }
        catch (MalformedChunkCodingException malformedChunkCodingException) {
            this.state = ChunkedInputStream$State.CHUNK_INVALID;
            throw malformedChunkCodingException;
        }
    }

    private long getChunkSize() throws IOException {
        ChunkedInputStream$State chunkedInputStream$State = this.state;
        switch (chunkedInputStream$State) {
            case CHUNK_CRLF: {
                this.lineBuffer.clear();
                int n2 = this.buffer.readLine(this.lineBuffer, this.inputStream);
                if (n2 == -1) {
                    throw new MalformedChunkCodingException("CRLF expected at end of chunk");
                }
                if (!this.lineBuffer.isEmpty()) {
                    throw new MalformedChunkCodingException("Unexpected content at the end of chunk");
                }
                this.state = ChunkedInputStream$State.CHUNK_LEN;
            }
            case CHUNK_LEN: {
                this.lineBuffer.clear();
                int n3 = this.buffer.readLine(this.lineBuffer, this.inputStream);
                if (n3 == -1) {
                    throw new ConnectionClosedException("Premature end of chunk coded message body: closing chunk expected");
                }
                n3 = this.lineBuffer.indexOf(59);
                if (n3 < 0) {
                    n3 = this.lineBuffer.length();
                }
                String string = this.lineBuffer.substringTrimmed(0, n3);
                try {
                    return Long.parseLong(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedChunkCodingException("Bad chunk header: " + string);
                }
            }
        }
        throw new IllegalStateException("Inconsistent codec state");
    }

    private void parseTrailerHeaders() throws IOException {
        try {
            this.footers = AbstractMessageParser.parseHeaders(this.buffer, this.inputStream, this.http1Config.getMaxHeaderCount(), this.http1Config.getMaxLineLength(), null);
            return;
        }
        catch (HttpException httpException) {
            MalformedChunkCodingException malformedChunkCodingException = new MalformedChunkCodingException("Invalid trailing header: " + httpException.getMessage());
            malformedChunkCodingException.initCause(httpException);
            throw malformedChunkCodingException;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof && this.state != ChunkedInputStream$State.CHUNK_INVALID) {
                    if (this.chunkSize == this.pos && this.chunkSize > 0L && this.read() == -1) {
                        return;
                    }
                    byte[] byArray = new byte[2048];
                    while (this.read(byArray) >= 0) {
                    }
                }
                return;
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }

    public Header[] getFooters() {
        if (this.footers.length > 0) {
            return (Header[])this.footers.clone();
        }
        return EMPTY_FOOTERS;
    }
}

