/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import javax.net.ssl.SSLSocket;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.io.BHttpConnectionBase;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestParserFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseWriterFactory;
import org.apache.hc.core5.http.impl.io.SocketHolder;
import org.apache.hc.core5.http.io.HttpMessageParser;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriter;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.HttpServerConnection;
import org.apache.hc.core5.util.Args;

public class DefaultBHttpServerConnection
extends BHttpConnectionBase
implements HttpServerConnection {
    private final String scheme;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final HttpMessageParser<ClassicHttpRequest> requestParser;
    private final HttpMessageWriter<ClassicHttpResponse> responseWriter;

    public DefaultBHttpServerConnection(String string, Http1Config http1Config, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, HttpMessageParserFactory<ClassicHttpRequest> defaultHttpRequestParserFactory, HttpMessageWriterFactory<ClassicHttpResponse> defaultHttpResponseWriterFactory) {
        super(http1Config, charsetDecoder, charsetEncoder);
        this.scheme = string != null ? string : URIScheme.HTTP.getId();
        this.requestParser = (defaultHttpRequestParserFactory != null ? defaultHttpRequestParserFactory : DefaultHttpRequestParserFactory.INSTANCE).create();
        this.responseWriter = (defaultHttpResponseWriterFactory != null ? defaultHttpResponseWriterFactory : DefaultHttpResponseWriterFactory.INSTANCE).create();
        this.incomingContentStrategy = contentLengthStrategy != null ? contentLengthStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = contentLengthStrategy2 != null ? contentLengthStrategy2 : DefaultContentLengthStrategy.INSTANCE;
    }

    public DefaultBHttpServerConnection(String string, Http1Config http1Config, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder) {
        this(string, http1Config, charsetDecoder, charsetEncoder, null, null, null, null);
    }

    public DefaultBHttpServerConnection(String string, Http1Config http1Config) {
        this(string, http1Config, null, null);
    }

    protected void onRequestReceived(ClassicHttpRequest classicHttpRequest) {
    }

    protected void onResponseSubmitted(ClassicHttpResponse classicHttpResponse) {
    }

    @Override
    public void bind(Socket socket) throws IOException {
        super.bind(socket);
    }

    public void bind(SSLSocket sSLSocket, Socket socket) throws IOException {
        super.bind(new SocketHolder(sSLSocket, socket));
    }

    @Override
    public ClassicHttpRequest receiveRequestHeader() throws HttpException, IOException {
        Object object = this.ensureOpen();
        if ((object = this.requestParser.parse(this.inBuffer, ((SocketHolder)object).getInputStream())) == null) {
            return null;
        }
        ProtocolVersion protocolVersion = object.getVersion();
        if (protocolVersion != null && protocolVersion.greaterEquals(HttpVersion.HTTP_2)) {
            throw new UnsupportedHttpVersionException(protocolVersion);
        }
        object.setScheme(this.scheme);
        this.version = protocolVersion;
        this.onRequestReceived((ClassicHttpRequest)object);
        this.incrementRequestCount();
        return object;
    }

    @Override
    public void receiveRequestEntity(ClassicHttpRequest classicHttpRequest) throws HttpException, IOException {
        Args.notNull(classicHttpRequest, "HTTP request");
        SocketHolder socketHolder = this.ensureOpen();
        long l2 = this.incomingContentStrategy.determineLength(classicHttpRequest);
        if (l2 == -9223372036854775807L) {
            return;
        }
        classicHttpRequest.setEntity(this.createIncomingEntity(classicHttpRequest, this.inBuffer, socketHolder.getInputStream(), l2));
    }

    @Override
    public void sendResponseHeader(ClassicHttpResponse classicHttpResponse) throws HttpException, IOException {
        Args.notNull(classicHttpResponse, "HTTP response");
        SocketHolder socketHolder = this.ensureOpen();
        this.responseWriter.write(classicHttpResponse, this.outbuffer, socketHolder.getOutputStream());
        this.onResponseSubmitted(classicHttpResponse);
        if (classicHttpResponse.getCode() >= 200) {
            this.incrementResponseCount();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendResponseEntity(ClassicHttpResponse closeable) throws HttpException, IOException {
        Args.notNull(closeable, "HTTP response");
        Object object = this.ensureOpen();
        Object object2 = closeable.getEntity();
        if (object2 == null) {
            return;
        }
        long l2 = this.outgoingContentStrategy.determineLength((HttpMessage)((Object)closeable));
        closeable = this.createContentOutputStream(l2, this.outbuffer, ((SocketHolder)object).getOutputStream(), object2.getTrailers());
        object = null;
        try {
            object2.writeTo((OutputStream)closeable);
            if (closeable == null) return;
        }
        catch (Throwable throwable) {
            try {
                object2 = throwable;
                object = throwable;
                throw object2;
            }
            catch (Throwable throwable2) {
                if (closeable == null) throw throwable2;
                if (object != null) {
                    try {
                        ((OutputStream)closeable).close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object).addSuppressed(throwable3);
                    }
                    throw throwable2;
                } else {
                    ((OutputStream)closeable).close();
                }
                throw throwable2;
            }
        }
        ((OutputStream)closeable).close();
        return;
    }
}

