/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.CharCodingSupport;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnection;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnectionFactory$Builder;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestParserFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseWriterFactory;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultBHttpServerConnectionFactory
implements HttpConnectionFactory<DefaultBHttpServerConnection> {
    private final String scheme;
    private final Http1Config http1Config;
    private final CharCodingConfig charCodingConfig;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final HttpMessageParserFactory<ClassicHttpRequest> requestParserFactory;
    private final HttpMessageWriterFactory<ClassicHttpResponse> responseWriterFactory;

    public DefaultBHttpServerConnectionFactory(String string, Http1Config http1Config, CharCodingConfig charCodingConfig, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, HttpMessageParserFactory<ClassicHttpRequest> defaultHttpRequestParserFactory, HttpMessageWriterFactory<ClassicHttpResponse> defaultHttpResponseWriterFactory) {
        this.scheme = string;
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.incomingContentStrategy = contentLengthStrategy;
        this.outgoingContentStrategy = contentLengthStrategy2;
        this.requestParserFactory = defaultHttpRequestParserFactory != null ? defaultHttpRequestParserFactory : new DefaultHttpRequestParserFactory(this.http1Config);
        this.responseWriterFactory = defaultHttpResponseWriterFactory != null ? defaultHttpResponseWriterFactory : new DefaultHttpResponseWriterFactory(this.http1Config);
    }

    public DefaultBHttpServerConnectionFactory(String string, Http1Config http1Config, CharCodingConfig charCodingConfig, HttpMessageParserFactory<ClassicHttpRequest> httpMessageParserFactory, HttpMessageWriterFactory<ClassicHttpResponse> httpMessageWriterFactory) {
        this(string, http1Config, charCodingConfig, null, null, httpMessageParserFactory, httpMessageWriterFactory);
    }

    public DefaultBHttpServerConnectionFactory(String string, Http1Config http1Config, CharCodingConfig charCodingConfig) {
        this(string, http1Config, charCodingConfig, null, null, null, null);
    }

    DefaultBHttpServerConnection createDetached(Socket socket) {
        return new DefaultBHttpServerConnection(this.scheme != null ? this.scheme : (socket instanceof SSLSocket ? URIScheme.HTTPS.id : URIScheme.HTTP.id), this.http1Config, CharCodingSupport.createDecoder(this.charCodingConfig), CharCodingSupport.createEncoder(this.charCodingConfig), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestParserFactory, this.responseWriterFactory);
    }

    @Override
    public DefaultBHttpServerConnection createConnection(Socket socket) throws IOException {
        DefaultBHttpServerConnection defaultBHttpServerConnection = this.createDetached(socket);
        defaultBHttpServerConnection.bind(socket);
        return defaultBHttpServerConnection;
    }

    @Override
    public DefaultBHttpServerConnection createConnection(SSLSocket sSLSocket, Socket socket) throws IOException {
        DefaultBHttpServerConnection defaultBHttpServerConnection = this.createDetached(sSLSocket);
        defaultBHttpServerConnection.bind(sSLSocket, socket);
        return defaultBHttpServerConnection;
    }

    public static DefaultBHttpServerConnectionFactory$Builder builder() {
        return new DefaultBHttpServerConnectionFactory$Builder(null);
    }
}

