/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequestFactory;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.RequestHeaderFieldsTooLargeException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpRequestFactory;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpRequestParser
extends AbstractMessageParser<ClassicHttpRequest> {
    private final HttpRequestFactory<ClassicHttpRequest> requestFactory;

    public DefaultHttpRequestParser(Http1Config http1Config, LineParser lineParser, HttpRequestFactory<ClassicHttpRequest> defaultClassicHttpRequestFactory) {
        super(http1Config, lineParser);
        this.requestFactory = defaultClassicHttpRequestFactory != null ? defaultClassicHttpRequestFactory : DefaultClassicHttpRequestFactory.INSTANCE;
    }

    @Deprecated
    public DefaultHttpRequestParser(LineParser lineParser, HttpRequestFactory<ClassicHttpRequest> httpRequestFactory, Http1Config http1Config) {
        this(http1Config, lineParser, httpRequestFactory);
    }

    public DefaultHttpRequestParser(Http1Config http1Config) {
        this(http1Config, null, null);
    }

    public DefaultHttpRequestParser() {
        this(Http1Config.DEFAULT, null, null);
    }

    @Override
    public ClassicHttpRequest parse(SessionInputBuffer sessionInputBuffer, InputStream inputStream) throws IOException, HttpException {
        try {
            return (ClassicHttpRequest)super.parse(sessionInputBuffer, inputStream);
        }
        catch (MessageConstraintException messageConstraintException) {
            throw new RequestHeaderFieldsTooLargeException(messageConstraintException.getMessage(), messageConstraintException);
        }
    }

    @Override
    protected ClassicHttpRequest createMessage(CharArrayBuffer serializable) throws IOException, HttpException {
        serializable = this.getLineParser().parseRequestLine((CharArrayBuffer)serializable);
        ClassicHttpRequest classicHttpRequest = this.requestFactory.newHttpRequest(((RequestLine)serializable).getMethod(), ((RequestLine)serializable).getUri());
        classicHttpRequest.setVersion(((RequestLine)serializable).getProtocolVersion());
        return classicHttpRequest;
    }
}

