/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.ResponseOutOfOrderStrategy;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class MonitoringResponseOutOfOrderStrategy
implements ResponseOutOfOrderStrategy {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    public static final MonitoringResponseOutOfOrderStrategy INSTANCE = new MonitoringResponseOutOfOrderStrategy();
    private final long chunkSize;
    private final long maxChunksToCheck;

    public MonitoringResponseOutOfOrderStrategy() {
        this(8192L);
    }

    public MonitoringResponseOutOfOrderStrategy(long l2) {
        this(l2, Long.MAX_VALUE);
    }

    public MonitoringResponseOutOfOrderStrategy(long l2, long l3) {
        this.chunkSize = Args.positive(l2, "chunkSize");
        this.maxChunksToCheck = Args.positive(l3, "maxChunksToCheck");
    }

    @Override
    public final boolean isEarlyResponseDetected(ClassicHttpRequest classicHttpRequest, HttpClientConnection httpClientConnection, InputStream inputStream, long l2, long l3) throws IOException {
        if (this.nextWriteStartsNewChunk(l2, l3)) {
            boolean bl2 = httpClientConnection.getSSLSession() != null;
            if (bl2) {
                return httpClientConnection.isDataAvailable(Timeout.ONE_MILLISECOND);
            }
            return inputStream.available() > 0;
        }
        return false;
    }

    private boolean nextWriteStartsNewChunk(long l2, long l3) {
        long l4;
        long l5 = Math.min(l2 / this.chunkSize, this.maxChunksToCheck);
        return l5 < (l4 = Math.min((l2 + l3) / this.chunkSize, this.maxChunksToCheck));
    }

    public final String toString() {
        return "DefaultResponseOutOfOrderStrategy{chunkSize=" + this.chunkSize + ", maxChunksToCheck=" + this.maxChunksToCheck + '}';
    }
}

