/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.io.HttpTransportMetrics;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;

public class SessionInputBufferImpl
implements SessionInputBuffer {
    private final BasicHttpTransportMetrics metrics;
    private final byte[] buffer;
    private final ByteArrayBuffer lineBuffer;
    private final int minChunkLimit;
    private final int maxLineLen;
    private final CharsetDecoder decoder;
    private int bufferPos;
    private int bufferLen;
    private CharBuffer cbuf;

    public SessionInputBufferImpl(BasicHttpTransportMetrics basicHttpTransportMetrics, int n2, int n3, int n4, CharsetDecoder charsetDecoder) {
        Args.notNull(basicHttpTransportMetrics, "HTTP transport metrics");
        Args.positive(n2, "Buffer size");
        this.metrics = basicHttpTransportMetrics;
        this.buffer = new byte[n2];
        this.bufferPos = 0;
        this.bufferLen = 0;
        this.minChunkLimit = n3 >= 0 ? n3 : 512;
        this.maxLineLen = Math.max(n4, 0);
        this.lineBuffer = new ByteArrayBuffer(n2);
        this.decoder = charsetDecoder;
    }

    public SessionInputBufferImpl(BasicHttpTransportMetrics basicHttpTransportMetrics, int n2) {
        int n3 = n2;
        this(basicHttpTransportMetrics, n3, n3, 0, null);
    }

    public SessionInputBufferImpl(int n2, int n3) {
        int n4 = n2;
        this(new BasicHttpTransportMetrics(), n4, n4, n3, null);
    }

    public SessionInputBufferImpl(int n2, CharsetDecoder charsetDecoder) {
        int n3 = n2;
        this(new BasicHttpTransportMetrics(), n3, n3, 0, charsetDecoder);
    }

    public SessionInputBufferImpl(int n2) {
        int n3 = n2;
        this(new BasicHttpTransportMetrics(), n3, n3, 0, null);
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public int length() {
        return this.bufferLen - this.bufferPos;
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    public int fillBuffer(InputStream inputStream) throws IOException {
        int n2;
        Args.notNull(inputStream, "Input stream");
        if (this.bufferPos > 0) {
            n2 = this.bufferLen - this.bufferPos;
            if (n2 > 0) {
                System.arraycopy(this.buffer, this.bufferPos, this.buffer, 0, n2);
            }
            this.bufferPos = 0;
            this.bufferLen = n2;
        }
        int n3 = this.bufferLen;
        n2 = this.buffer.length - n3;
        if ((n2 = inputStream.read(this.buffer, n3, n2)) == -1) {
            return -1;
        }
        this.bufferLen = n3 + n2;
        this.metrics.incrementBytesTransferred(n2);
        return n2;
    }

    public boolean hasBufferedData() {
        return this.bufferPos < this.bufferLen;
    }

    public void clear() {
        this.bufferPos = 0;
        this.bufferLen = 0;
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        Args.notNull(inputStream, "Input stream");
        while (!this.hasBufferedData()) {
            int n2 = this.fillBuffer(inputStream);
            if (n2 != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferPos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3, InputStream inputStream) throws IOException {
        int n4;
        Args.notNull(inputStream, "Input stream");
        if (byArray == null || byArray.length == 0 || n3 == 0) {
            return 0;
        }
        if (this.hasBufferedData()) {
            int n5 = Math.min(n3, this.bufferLen - this.bufferPos);
            System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n5);
            this.bufferPos += n5;
            return n5;
        }
        if (n3 > this.minChunkLimit) {
            int n6 = inputStream.read(byArray, n2, n3);
            if (n6 > 0) {
                this.metrics.incrementBytesTransferred(n6);
            }
            return n6;
        }
        while (!this.hasBufferedData()) {
            n4 = this.fillBuffer(inputStream);
            if (n4 != -1) continue;
            return -1;
        }
        n4 = Math.min(n3, this.bufferLen - this.bufferPos);
        System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n4);
        this.bufferPos += n4;
        return n4;
    }

    @Override
    public int read(byte[] byArray, InputStream inputStream) throws IOException {
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length, inputStream);
    }

    @Override
    public int readLine(CharArrayBuffer charArrayBuffer, InputStream inputStream) throws IOException {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(inputStream, "Input stream");
        int n2 = 0;
        boolean bl2 = true;
        while (bl2) {
            int n3;
            int n4 = -1;
            for (n3 = this.bufferPos; n3 < this.bufferLen; ++n3) {
                if (this.buffer[n3] != 10) continue;
                n4 = n3;
                break;
            }
            if (this.maxLineLen > 0 && (n3 = this.lineBuffer.length() + (n4 >= 0 ? n4 : this.bufferLen) - this.bufferPos) >= this.maxLineLen) {
                throw new MessageConstraintException("Maximum line length limit exceeded");
            }
            if (n4 != -1) {
                if (this.lineBuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charArrayBuffer, n4);
                }
                bl2 = false;
                n3 = n4 + 1 - this.bufferPos;
                this.lineBuffer.append(this.buffer, this.bufferPos, n3);
                this.bufferPos = n4 + 1;
                continue;
            }
            if (this.hasBufferedData()) {
                n3 = this.bufferLen - this.bufferPos;
                this.lineBuffer.append(this.buffer, this.bufferPos, n3);
                this.bufferPos = this.bufferLen;
            }
            if ((n2 = this.fillBuffer(inputStream)) != -1) continue;
            bl2 = false;
        }
        if (n2 == -1 && this.lineBuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer(charArrayBuffer);
    }

    private int lineFromLineBuffer(CharArrayBuffer charArrayBuffer) throws IOException {
        int n2 = this.lineBuffer.length();
        if (n2 > 0) {
            if (this.lineBuffer.byteAt(n2 - 1) == 10) {
                --n2;
            }
            if (n2 > 0 && this.lineBuffer.byteAt(n2 - 1) == 13) {
                --n2;
            }
        }
        if (this.decoder == null) {
            charArrayBuffer.append(this.lineBuffer, 0, n2);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.lineBuffer.array(), 0, n2);
            n2 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        this.lineBuffer.clear();
        return n2;
    }

    private int lineFromReadBuffer(CharArrayBuffer charArrayBuffer, int n2) throws IOException {
        int n3 = this.bufferPos;
        this.bufferPos = n2 + 1;
        if (n2 > n3 && this.buffer[n2 - 1] == 13) {
            --n2;
        }
        n2 -= n3;
        if (this.decoder == null) {
            charArrayBuffer.append(this.buffer, n3, n2);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer, n3, n2);
            n2 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        return n2;
    }

    private int appendDecoded(CharArrayBuffer charArrayBuffer, ByteBuffer byteBuffer) throws IOException {
        CoderResult coderResult;
        if (!byteBuffer.hasRemaining()) {
            return 0;
        }
        if (this.cbuf == null) {
            this.cbuf = CharBuffer.allocate(1024);
        }
        this.decoder.reset();
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            coderResult = this.decoder.decode(byteBuffer, this.cbuf, true);
            n2 += this.handleDecodingResult(coderResult, charArrayBuffer);
        }
        coderResult = this.decoder.flush(this.cbuf);
        this.cbuf.clear();
        return n2 += this.handleDecodingResult(coderResult, charArrayBuffer);
    }

    private int handleDecodingResult(CoderResult coderResult, CharArrayBuffer charArrayBuffer) throws IOException {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.cbuf.flip();
        int n2 = this.cbuf.remaining();
        while (this.cbuf.hasRemaining()) {
            charArrayBuffer.append(this.cbuf.get());
        }
        this.cbuf.compact();
        return n2;
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

