/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.io.HttpTransportMetrics;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;

public class SessionOutputBufferImpl
implements SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final BasicHttpTransportMetrics metrics;
    private final ByteArrayBuffer buffer;
    private final int fragmentSizeHint;
    private final CharsetEncoder encoder;
    private ByteBuffer bbuf;

    public SessionOutputBufferImpl(BasicHttpTransportMetrics basicHttpTransportMetrics, int n2, int n3, CharsetEncoder charsetEncoder) {
        Args.positive(n2, "Buffer size");
        Args.notNull(basicHttpTransportMetrics, "HTTP transport metrics");
        this.metrics = basicHttpTransportMetrics;
        this.buffer = new ByteArrayBuffer(n2);
        this.fragmentSizeHint = n3 >= 0 ? n3 : n2;
        this.encoder = charsetEncoder;
    }

    public SessionOutputBufferImpl(int n2) {
        int n3 = n2;
        this(new BasicHttpTransportMetrics(), n3, n3, null);
    }

    public SessionOutputBufferImpl(int n2, CharsetEncoder charsetEncoder) {
        int n3 = n2;
        this(new BasicHttpTransportMetrics(), n3, n3, charsetEncoder);
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    private void flushBuffer(OutputStream outputStream) throws IOException {
        int n2 = this.buffer.length();
        if (n2 > 0) {
            outputStream.write(this.buffer.array(), 0, n2);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred(n2);
        }
    }

    @Override
    public void flush(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        this.flushBuffer(outputStream);
        outputStream.flush();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3, OutputStream outputStream) throws IOException {
        if (byArray == null) {
            return;
        }
        Args.notNull(outputStream, "Output stream");
        if (n3 > this.fragmentSizeHint || n3 > this.buffer.capacity()) {
            this.flushBuffer(outputStream);
            outputStream.write(byArray, n2, n3);
            this.metrics.incrementBytesTransferred(n3);
            return;
        }
        int n4 = this.buffer.capacity() - this.buffer.length();
        if (n3 > n4) {
            this.flushBuffer(outputStream);
        }
        this.buffer.append(byArray, n2, n3);
    }

    @Override
    public void write(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray == null) {
            return;
        }
        this.write(byArray, 0, byArray.length, outputStream);
    }

    @Override
    public void write(int n2, OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        if (this.fragmentSizeHint > 0) {
            if (this.buffer.isFull()) {
                this.flushBuffer(outputStream);
            }
            this.buffer.append(n2);
            return;
        }
        this.flushBuffer(outputStream);
        outputStream.write(n2);
    }

    @Override
    public void writeLine(CharArrayBuffer charArrayBuffer, OutputStream outputStream) throws IOException {
        if (charArrayBuffer == null) {
            return;
        }
        Args.notNull(outputStream, "Output stream");
        if (this.encoder == null) {
            int n2;
            int n3 = 0;
            for (int i2 = charArrayBuffer.length(); i2 > 0; i2 -= n2) {
                n2 = this.buffer.capacity() - this.buffer.length();
                if ((n2 = Math.min(n2, i2)) > 0) {
                    this.buffer.append(charArrayBuffer, n3, n2);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer(outputStream);
                }
                n3 += n2;
            }
        } else {
            CharBuffer charBuffer = CharBuffer.wrap(charArrayBuffer.array(), 0, charArrayBuffer.length());
            this.writeEncoded(charBuffer, outputStream);
        }
        this.write(CRLF, outputStream);
    }

    private void writeEncoded(CharBuffer charBuffer, OutputStream outputStream) throws IOException {
        CoderResult coderResult;
        if (!charBuffer.hasRemaining()) {
            return;
        }
        if (this.bbuf == null) {
            this.bbuf = ByteBuffer.allocate(1024);
        }
        this.encoder.reset();
        while (charBuffer.hasRemaining()) {
            coderResult = this.encoder.encode(charBuffer, this.bbuf, true);
            this.handleEncodingResult(coderResult, outputStream);
        }
        coderResult = this.encoder.flush(this.bbuf);
        this.handleEncodingResult(coderResult, outputStream);
        this.bbuf.clear();
    }

    private void handleEncodingResult(CoderResult coderResult, OutputStream outputStream) throws IOException {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.bbuf.flip();
        while (this.bbuf.hasRemaining()) {
            SessionOutputBufferImpl sessionOutputBufferImpl = this;
            sessionOutputBufferImpl.write(sessionOutputBufferImpl.bbuf.get(), outputStream);
        }
        this.bbuf.compact();
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

