/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocket;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.util.Args;

public class SocketHolder {
    private final SSLSocket sslSocket;
    private final Socket baseSocket;
    private final AtomicReference<InputStream> inputStreamRef;
    private final AtomicReference<OutputStream> outputStreamRef;

    public SocketHolder(SSLSocket sSLSocket, Socket socket) {
        this.sslSocket = Args.notNull(sSLSocket, "SSL Socket");
        this.baseSocket = Args.notNull(socket, "Socket");
        this.inputStreamRef = new AtomicReference();
        this.outputStreamRef = new AtomicReference();
    }

    public SocketHolder(Socket socket) {
        this.baseSocket = Args.notNull(socket, "Socket");
        this.sslSocket = null;
        this.inputStreamRef = new AtomicReference();
        this.outputStreamRef = new AtomicReference();
    }

    public final Socket getSocket() {
        if (this.sslSocket != null) {
            return this.sslSocket;
        }
        return this.baseSocket;
    }

    @Internal
    public Socket getBaseSocket() {
        return this.baseSocket;
    }

    @Internal
    public SSLSocket getSSLSocket() {
        return this.sslSocket;
    }

    public final InputStream getInputStream() throws IOException {
        InputStream inputStream = this.inputStreamRef.get();
        if (inputStream != null) {
            return inputStream;
        }
        SocketHolder socketHolder = this;
        inputStream = socketHolder.getInputStream(socketHolder.getSocket());
        if (this.inputStreamRef.compareAndSet(null, inputStream)) {
            return inputStream;
        }
        return this.inputStreamRef.get();
    }

    protected InputStream getInputStream(Socket socket) throws IOException {
        return socket.getInputStream();
    }

    protected OutputStream getOutputStream(Socket socket) throws IOException {
        return socket.getOutputStream();
    }

    public final OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = this.outputStreamRef.get();
        if (outputStream != null) {
            return outputStream;
        }
        SocketHolder socketHolder = this;
        outputStream = socketHolder.getOutputStream(socketHolder.getSocket());
        if (this.outputStreamRef.compareAndSet(null, outputStream)) {
            return outputStream;
        }
        return this.outputStreamRef.get();
    }

    public String toString() {
        return "SocketHolder{sslSocket=" + this.sslSocket + ", baseSocket=" + this.baseSocket + '}';
    }
}

