/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.nio.ContentDecoder;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.util.Args;

public abstract class AbstractContentDecoder
implements ContentDecoder {
    final ReadableByteChannel channel;
    final SessionInputBuffer buffer;
    final BasicHttpTransportMetrics metrics;
    protected boolean completed;

    public AbstractContentDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) {
        Args.notNull(readableByteChannel, "Channel");
        Args.notNull(sessionInputBuffer, "Session input buffer");
        Args.notNull(basicHttpTransportMetrics, "Transport metrics");
        this.buffer = sessionInputBuffer;
        this.channel = readableByteChannel;
        this.metrics = basicHttpTransportMetrics;
    }

    protected ReadableByteChannel channel() {
        return this.channel;
    }

    protected SessionInputBuffer buffer() {
        return this.buffer;
    }

    protected BasicHttpTransportMetrics metrics() {
        return this.metrics;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean bl2) {
        this.completed = bl2;
    }

    protected void setCompleted() {
        this.completed = true;
    }

    protected int readFromChannel(ByteBuffer byteBuffer) throws IOException {
        int n2 = this.channel.read(byteBuffer);
        if (n2 > 0) {
            this.metrics.incrementBytesTransferred(n2);
        }
        return n2;
    }

    protected int fillBufferFromChannel() throws IOException {
        int n2 = this.buffer.fill(this.channel);
        if (n2 > 0) {
            this.metrics.incrementBytesTransferred(n2);
        }
        return n2;
    }

    protected int readFromChannel(ByteBuffer byteBuffer, int n2) throws IOException {
        if (byteBuffer.remaining() > n2) {
            int n3 = byteBuffer.limit();
            n2 = n3 - (byteBuffer.remaining() - n2);
            byteBuffer.limit(n2);
            n2 = this.channel.read(byteBuffer);
            byteBuffer.limit(n3);
        } else {
            n2 = this.channel.read(byteBuffer);
        }
        if (n2 > 0) {
            this.metrics.incrementBytesTransferred(n2);
        }
        return n2;
    }

    @Override
    public List<? extends Header> getTrailers() {
        return null;
    }
}

