/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.nio.ContentEncoder;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public abstract class AbstractContentEncoder
implements ContentEncoder {
    final WritableByteChannel channel;
    final SessionOutputBuffer buffer;
    final BasicHttpTransportMetrics metrics;
    boolean completed;

    public AbstractContentEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) {
        Args.notNull(writableByteChannel, "Channel");
        Args.notNull(sessionOutputBuffer, "Session input buffer");
        Args.notNull(basicHttpTransportMetrics, "Transport metrics");
        this.buffer = sessionOutputBuffer;
        this.channel = writableByteChannel;
        this.metrics = basicHttpTransportMetrics;
    }

    protected WritableByteChannel channel() {
        return this.channel;
    }

    protected SessionOutputBuffer buffer() {
        return this.buffer;
    }

    protected BasicHttpTransportMetrics metrics() {
        return this.metrics;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void complete(List<? extends Header> list) throws IOException {
        this.completed = true;
    }

    public final void complete() throws IOException {
        this.complete(null);
    }

    protected void assertNotCompleted() {
        Asserts.check(!this.completed, "Encoding process already completed");
    }

    protected int flushToChannel() throws IOException {
        if (!this.buffer.hasData()) {
            return 0;
        }
        int n2 = this.buffer.flush(this.channel);
        if (n2 > 0) {
            this.metrics.incrementBytesTransferred(n2);
        }
        return n2;
    }

    protected int writeToChannel(ByteBuffer byteBuffer) throws IOException {
        if (!byteBuffer.hasRemaining()) {
            return 0;
        }
        int n2 = this.channel.write(byteBuffer);
        if (n2 > 0) {
            this.metrics.incrementBytesTransferred(n2);
        }
        return n2;
    }

    protected int writeToChannel(ByteBuffer byteBuffer, int n2) throws IOException {
        return this.doWriteChunk(byteBuffer, n2, true);
    }

    protected int writeToBuffer(ByteBuffer byteBuffer, int n2) throws IOException {
        return this.doWriteChunk(byteBuffer, n2, false);
    }

    private int doWriteChunk(ByteBuffer byteBuffer, int n2, boolean bl2) throws IOException {
        if (byteBuffer.remaining() > n2) {
            int n3 = byteBuffer.limit();
            n2 = n3 - (byteBuffer.remaining() - n2);
            byteBuffer.limit(n2);
            n2 = this.doWriteChunk(byteBuffer, bl2);
            byteBuffer.limit(n3);
        } else {
            n2 = this.doWriteChunk(byteBuffer, bl2);
        }
        return n2;
    }

    private int doWriteChunk(ByteBuffer byteBuffer, boolean n2) throws IOException {
        if (n2) {
            n2 = this.channel.write(byteBuffer);
            if (n2 > 0) {
                this.metrics.incrementBytesTransferred(n2);
            }
            return (int)n2;
        }
        n2 = byteBuffer.remaining();
        this.buffer.write(byteBuffer);
        return (int)n2;
    }
}

