/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.reactor.IOSession;

class AbstractHttp1StreamDuplexer$CapacityWindow
implements CapacityChannel {
    private final IOSession ioSession;
    private final ReentrantLock lock;
    private int window;
    private boolean closed;

    AbstractHttp1StreamDuplexer$CapacityWindow(int n2, IOSession iOSession) {
        this.window = n2;
        this.ioSession = iOSession;
        this.lock = new ReentrantLock();
    }

    @Override
    public void update(int n2) throws IOException {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (n2 > 0) {
                this.updateWindow(n2);
                this.ioSession.setEvent(1);
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    int removeCapacity(int n2) {
        this.lock.lock();
        try {
            this.updateWindow(-n2);
            if (this.window <= 0) {
                this.ioSession.clearEvent(1);
            }
            n2 = this.window;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateWindow(int n2) {
        int n3 = this.window + n2;
        if (((this.window ^ n3) & (n2 ^ n3)) < 0) {
            n3 = n2 < 0 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        this.window = n3;
    }

    void close() {
        this.lock.lock();
        try {
            this.closed = true;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    int getWindow() {
        return this.window;
    }
}

