/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.nio.AbstractMessageParser$State;
import org.apache.hc.core5.http.message.LazyLineParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.nio.NHttpMessageParser;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public abstract class AbstractMessageParser<T extends HttpMessage>
implements NHttpMessageParser<T> {
    private final Http1Config http1Config;
    private final LineParser lineParser;
    private AbstractMessageParser$State state;
    private T message;
    private CharArrayBuffer lineBuf;
    private final List<CharArrayBuffer> headerBufs;
    private int emptyLineCount;

    public AbstractMessageParser(Http1Config http1Config, LineParser lineParser) {
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.lineParser = lineParser != null ? lineParser : LazyLineParser.INSTANCE;
        this.headerBufs = new ArrayList<CharArrayBuffer>();
        this.state = AbstractMessageParser$State.READ_HEAD_LINE;
    }

    @Deprecated
    public AbstractMessageParser(LineParser lineParser, Http1Config http1Config) {
        this(http1Config, lineParser);
    }

    LineParser getLineParser() {
        return this.lineParser;
    }

    @Override
    public void reset() {
        this.state = AbstractMessageParser$State.READ_HEAD_LINE;
        this.headerBufs.clear();
        this.emptyLineCount = 0;
        this.message = null;
    }

    protected abstract T createMessage(CharArrayBuffer var1) throws HttpException;

    private T parseHeadLine() throws IOException, HttpException {
        if (this.lineBuf.isEmpty()) {
            ++this.emptyLineCount;
            if (this.emptyLineCount >= this.http1Config.getMaxEmptyLineCount()) {
                throw new MessageConstraintException("Maximum empty line limit exceeded");
            }
            return null;
        }
        AbstractMessageParser abstractMessageParser = this;
        return abstractMessageParser.createMessage(abstractMessageParser.lineBuf);
    }

    private void parseHeader() throws IOException {
        CharArrayBuffer charArrayBuffer = this.lineBuf;
        int n2 = this.headerBufs.size();
        if ((this.lineBuf.charAt(0) == ' ' || this.lineBuf.charAt(0) == '\t') && n2 > 0) {
            int n3;
            int n4;
            CharArrayBuffer charArrayBuffer2 = this.headerBufs.get(n2 - 1);
            for (n4 = 0; n4 < charArrayBuffer.length() && ((n3 = charArrayBuffer.charAt(n4)) == 32 || n3 == 9); ++n4) {
            }
            n3 = this.http1Config.getMaxLineLength();
            if (n3 > 0 && charArrayBuffer2.length() + 1 + charArrayBuffer.length() - n4 > n3) {
                throw new MessageConstraintException("Maximum line length limit exceeded");
            }
            charArrayBuffer2.append(' ');
            charArrayBuffer2.append(charArrayBuffer, n4, charArrayBuffer.length() - n4);
            return;
        }
        this.headerBufs.add(charArrayBuffer);
        this.lineBuf = null;
    }

    @Override
    public T parse(SessionInputBuffer sessionInputBuffer, boolean bl2) throws IOException, HttpException {
        Args.notNull(sessionInputBuffer, "Session input buffer");
        while (this.state != AbstractMessageParser$State.COMPLETED) {
            if (this.lineBuf == null) {
                this.lineBuf = new CharArrayBuffer(64);
            } else {
                this.lineBuf.clear();
            }
            int n2 = sessionInputBuffer.readLine(this.lineBuf, bl2);
            int n3 = this.http1Config.getMaxLineLength();
            if (n3 > 0 && (this.lineBuf.length() > n3 || n2 == 0 && sessionInputBuffer.length() > n3)) {
                throw new MessageConstraintException("Maximum line length limit exceeded");
            }
            if (n2 == 0) break;
            switch (this.state) {
                case READ_HEAD_LINE: {
                    this.message = this.parseHeadLine();
                    if (this.message == null) break;
                    this.state = AbstractMessageParser$State.READ_HEADERS;
                    break;
                }
                case READ_HEADERS: {
                    if (this.lineBuf.length() > 0) {
                        n2 = this.http1Config.getMaxHeaderCount();
                        if (n2 > 0 && this.headerBufs.size() >= n2) {
                            throw new MessageConstraintException("Maximum header count exceeded");
                        }
                        this.parseHeader();
                        break;
                    }
                    this.state = AbstractMessageParser$State.COMPLETED;
                }
            }
            if (!bl2 || sessionInputBuffer.hasData()) continue;
            this.state = AbstractMessageParser$State.COMPLETED;
        }
        if (this.state == AbstractMessageParser$State.COMPLETED) {
            for (CharArrayBuffer charArrayBuffer : this.headerBufs) {
                this.message.addHeader(this.lineParser.parseHeader(charArrayBuffer));
            }
            return this.message;
        }
        return null;
    }
}

