/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hc.core5.http.impl.nio.ExpandableBuffer;
import org.apache.hc.core5.util.Args;

public class BufferedData
extends ExpandableBuffer {
    public static BufferedData allocate(int n2) {
        return new BufferedData(n2);
    }

    protected BufferedData(int n2) {
        super(n2);
    }

    @Override
    public final boolean hasData() {
        return super.hasData();
    }

    @Override
    public final int length() {
        return super.length();
    }

    @Override
    public final int capacity() {
        return super.capacity();
    }

    @Override
    public final void clear() {
        super.clear();
    }

    public final void put(ByteBuffer byteBuffer) {
        Args.notNull(byteBuffer, "Data source");
        this.setInputMode();
        int n2 = this.buffer().position() + byteBuffer.remaining();
        this.ensureAdjustedCapacity(n2);
        this.buffer().put(byteBuffer);
    }

    public final int readFrom(ReadableByteChannel readableByteChannel) throws IOException {
        Args.notNull(readableByteChannel, "Channel");
        this.setInputMode();
        if (!this.buffer().hasRemaining()) {
            this.expand();
        }
        return readableByteChannel.read(this.buffer());
    }

    public final int writeTo(WritableByteChannel writableByteChannel) throws IOException {
        if (writableByteChannel == null) {
            return 0;
        }
        this.setOutputMode();
        return writableByteChannel.write(this.buffer());
    }

    public final ByteBuffer data() {
        this.setOutputMode();
        return this.buffer();
    }
}

