/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MalformedChunkCodingException;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.TruncatedChunkException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.AbstractContentDecoder;
import org.apache.hc.core5.http.impl.nio.ChunkDecoder$State;
import org.apache.hc.core5.http.message.BufferedHeader;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public class ChunkDecoder
extends AbstractContentDecoder {
    private ChunkDecoder$State state = ChunkDecoder$State.READ_CONTENT;
    private boolean endOfChunk = false;
    private boolean endOfStream = false;
    private CharArrayBuffer lineBuf;
    private long chunkSize = -1L;
    private long pos = 0L;
    private final Http1Config http1Config;
    private final List<CharArrayBuffer> trailerBufs;
    private final List<Header> trailers;

    public ChunkDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, Http1Config http1Config, BasicHttpTransportMetrics basicHttpTransportMetrics) {
        super(readableByteChannel, sessionInputBuffer, basicHttpTransportMetrics);
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.trailerBufs = new ArrayList<CharArrayBuffer>();
        this.trailers = new ArrayList<Header>();
    }

    public ChunkDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) {
        this(readableByteChannel, sessionInputBuffer, null, basicHttpTransportMetrics);
    }

    private void readChunkHead() throws IOException {
        if (this.lineBuf == null) {
            this.lineBuf = new CharArrayBuffer(32);
        } else {
            this.lineBuf.clear();
        }
        if (this.endOfChunk) {
            if (this.buffer.readLine(this.lineBuf, this.endOfStream)) {
                if (!this.lineBuf.isEmpty()) {
                    throw new MalformedChunkCodingException("CRLF expected at end of chunk");
                }
            } else {
                if (this.buffer.length() > 2 || this.endOfStream) {
                    throw new MalformedChunkCodingException("CRLF expected at end of chunk");
                }
                return;
            }
            this.endOfChunk = false;
        }
        int n2 = this.buffer.readLine(this.lineBuf, this.endOfStream);
        int n3 = this.http1Config.getMaxLineLength();
        if (n3 > 0 && (this.lineBuf.length() > n3 || n2 == 0 && this.buffer.length() > n3)) {
            throw new MessageConstraintException("Maximum line length limit exceeded");
        }
        if (n2 != 0) {
            n2 = this.lineBuf.indexOf(59);
            if (n2 < 0) {
                n2 = this.lineBuf.length();
            }
            String string = this.lineBuf.substringTrimmed(0, n2);
            try {
                this.chunkSize = Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedChunkCodingException("Bad chunk header: " + string);
            }
            this.pos = 0L;
            return;
        }
        if (this.endOfStream) {
            throw new ConnectionClosedException("Premature end of chunk coded message body: closing chunk expected");
        }
    }

    private void parseHeader() throws IOException {
        CharArrayBuffer charArrayBuffer = this.lineBuf;
        int n2 = this.trailerBufs.size();
        if ((this.lineBuf.charAt(0) == ' ' || this.lineBuf.charAt(0) == '\t') && n2 > 0) {
            int n3;
            int n4;
            CharArrayBuffer charArrayBuffer2 = this.trailerBufs.get(n2 - 1);
            for (n4 = 0; n4 < charArrayBuffer.length() && ((n3 = charArrayBuffer.charAt(n4)) == 32 || n3 == 9); ++n4) {
            }
            n3 = this.http1Config.getMaxLineLength();
            if (n3 > 0 && charArrayBuffer2.length() + 1 + charArrayBuffer.length() - n4 > n3) {
                throw new MessageConstraintException("Maximum line length limit exceeded");
            }
            charArrayBuffer2.append(' ');
            charArrayBuffer2.append(charArrayBuffer, n4, charArrayBuffer.length() - n4);
            return;
        }
        this.trailerBufs.add(charArrayBuffer);
        this.lineBuf = null;
    }

    private void processFooters() throws IOException {
        int n2 = this.trailerBufs.size();
        if (n2 > 0) {
            this.trailers.clear();
            for (n2 = 0; n2 < this.trailerBufs.size(); ++n2) {
                try {
                    this.trailers.add(new BufferedHeader(this.trailerBufs.get(n2)));
                    continue;
                }
                catch (ParseException parseException) {
                    throw new IOException(parseException);
                }
            }
        }
        this.trailerBufs.clear();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        Args.notNull(byteBuffer, "Byte buffer");
        if (this.state == ChunkDecoder$State.COMPLETED) {
            return -1;
        }
        int n2 = 0;
        while (this.state != ChunkDecoder$State.COMPLETED) {
            int n3;
            if (!(this.buffer.hasData() && this.chunkSize != -1L || (n3 = this.fillBufferFromChannel()) != -1)) {
                this.endOfStream = true;
            }
            switch (this.state) {
                case READ_CONTENT: {
                    long l2;
                    if (this.chunkSize == -1L) {
                        this.readChunkHead();
                        if (this.chunkSize == -1L) {
                            return n2;
                        }
                        if (this.chunkSize == 0L) {
                            this.chunkSize = -1L;
                            this.state = ChunkDecoder$State.READ_FOOTERS;
                            break;
                        }
                    }
                    if ((n3 = this.buffer.read(byteBuffer, (int)Math.min(l2 = this.chunkSize - this.pos, Integer.MAX_VALUE))) > 0) {
                        this.pos += (long)n3;
                        n2 += n3;
                    } else if (!this.buffer.hasData() && this.endOfStream) {
                        this.state = ChunkDecoder$State.COMPLETED;
                        this.setCompleted();
                        throw new TruncatedChunkException("Truncated chunk (expected size: %d; actual size: %d)", this.chunkSize, this.pos);
                    }
                    if (this.pos == this.chunkSize) {
                        this.chunkSize = -1L;
                        this.pos = 0L;
                        this.endOfChunk = true;
                        break;
                    }
                    return n2;
                }
                case READ_FOOTERS: {
                    if (this.lineBuf == null) {
                        this.lineBuf = new CharArrayBuffer(32);
                    } else {
                        this.lineBuf.clear();
                    }
                    if (!this.buffer.readLine(this.lineBuf, this.endOfStream)) {
                        if (this.endOfStream) {
                            this.state = ChunkDecoder$State.COMPLETED;
                            this.setCompleted();
                        }
                        return n2;
                    }
                    if (this.lineBuf.length() > 0) {
                        n3 = this.http1Config.getMaxHeaderCount();
                        if (n3 > 0 && this.trailerBufs.size() >= n3) {
                            throw new MessageConstraintException("Maximum header count exceeded");
                        }
                        this.parseHeader();
                        break;
                    }
                    this.state = ChunkDecoder$State.COMPLETED;
                    this.setCompleted();
                    this.processFooters();
                }
            }
        }
        return n2;
    }

    @Override
    public List<? extends Header> getTrailers() {
        if (this.trailers.isEmpty()) {
            return null;
        }
        return new ArrayList<Header>(this.trailers);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[chunk-coded; completed: ");
        stringBuilder.append(this.completed);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

