/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamHandler$1;
import org.apache.hc.core5.http.impl.nio.FlushMode;
import org.apache.hc.core5.http.impl.nio.Http1StreamChannel;
import org.apache.hc.core5.http.impl.nio.MessageState;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResourceHolder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.Timeout;

class ClientHttp1StreamHandler
implements ResourceHolder {
    public static final Timeout DEFAULT_WAIT_FOR_CONTINUE = Timeout.ofSeconds(3L);
    private final Http1StreamChannel<HttpRequest> outputChannel;
    private final DataStreamChannel internalDataChannel;
    private final HttpProcessor httpProcessor;
    private final Http1Config http1Config;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final AsyncClientExchangeHandler exchangeHandler;
    private final HttpCoreContext context;
    private final AtomicReference<MessageState> requestState;
    private final AtomicReference<MessageState> responseState;
    private final AtomicBoolean requestCommitted;
    private final AtomicBoolean done;
    private volatile boolean keepAlive;
    private volatile Timeout timeout;
    private volatile HttpRequest committedRequest;

    ClientHttp1StreamHandler(Http1StreamChannel<HttpRequest> http1StreamChannel, HttpProcessor httpProcessor, Http1Config http1Config, ConnectionReuseStrategy connectionReuseStrategy, AsyncClientExchangeHandler asyncClientExchangeHandler, HttpCoreContext httpCoreContext) {
        this.outputChannel = http1StreamChannel;
        this.internalDataChannel = new ClientHttp1StreamHandler$1(this, http1StreamChannel);
        this.httpProcessor = httpProcessor;
        this.http1Config = http1Config;
        this.connectionReuseStrategy = connectionReuseStrategy;
        this.exchangeHandler = asyncClientExchangeHandler;
        this.context = httpCoreContext;
        this.requestState = new AtomicReference<MessageState>(MessageState.IDLE);
        this.responseState = new AtomicReference<MessageState>(MessageState.HEADERS);
        this.requestCommitted = new AtomicBoolean();
        this.done = new AtomicBoolean();
        this.keepAlive = true;
    }

    boolean isRequestFinal() {
        return this.requestState.get() == MessageState.COMPLETE;
    }

    boolean isResponseFinal() {
        return this.responseState.get() == MessageState.COMPLETE;
    }

    boolean isCompleted() {
        return this.requestState.get() == MessageState.COMPLETE && this.responseState.get() == MessageState.COMPLETE;
    }

    String getRequestMethod() {
        if (this.committedRequest != null) {
            return this.committedRequest.getMethod();
        }
        return null;
    }

    boolean isOutputReady() {
        switch (this.requestState.get()) {
            case IDLE: {
                return true;
            }
            case HEADERS: 
            case ACK: {
                return false;
            }
            case BODY: {
                return this.exchangeHandler.available() > 0;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commitRequest(HttpRequest object, EntityDetails entityDetails) throws IOException, HttpException {
        if (!this.requestCommitted.compareAndSet(false, true)) throw new HttpException("Request already committed");
        ProtocolVersion protocolVersion = object.getVersion();
        if (protocolVersion != null && !protocolVersion.lessEquals(this.http1Config.getVersion())) {
            throw new UnsupportedHttpVersionException(protocolVersion);
        }
        this.context.setProtocolVersion(protocolVersion != null ? protocolVersion : this.http1Config.getVersion());
        this.context.setRequest((HttpRequest)object);
        this.httpProcessor.process((HttpRequest)object, entityDetails, (HttpContext)this.context);
        boolean bl2 = entityDetails == null;
        if (bl2) {
            this.committedRequest = object;
            this.requestState.set(MessageState.COMPLETE);
            this.outputChannel.submit((HttpRequest)object, true, FlushMode.IMMEDIATE);
            return;
        } else {
            Header header = object.getFirstHeader("Expect");
            boolean bl3 = header != null && "100-continue".equalsIgnoreCase(header.getValue());
            this.outputChannel.submit((HttpRequest)object, false, bl3 ? FlushMode.IMMEDIATE : FlushMode.BUFFER);
            this.committedRequest = object;
            if (bl3) {
                this.requestState.set(MessageState.ACK);
                this.timeout = this.outputChannel.getSocketTimeout();
                object = this.http1Config.getWaitForContinueTimeout() != null ? this.http1Config.getWaitForContinueTimeout() : DEFAULT_WAIT_FOR_CONTINUE;
                this.outputChannel.setSocketTimeout((Timeout)object);
                return;
            } else {
                this.exchangeHandler.produce(this.internalDataChannel);
                if (!this.requestState.compareAndSet(MessageState.HEADERS, MessageState.BODY)) return;
                this.outputChannel.requestOutput();
                return;
            }
        }
    }

    void produceOutput() throws HttpException, IOException {
        switch (this.requestState.get()) {
            case IDLE: {
                this.requestState.set(MessageState.HEADERS);
                this.outputChannel.suspendOutput();
                this.exchangeHandler.produceRequest((httpRequest, entityDetails, httpContext) -> this.commitRequest(httpRequest, entityDetails), this.context);
                return;
            }
            case ACK: {
                this.outputChannel.suspendOutput();
                return;
            }
            case BODY: {
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        }
    }

    void consumeHeader(HttpResponse httpResponse, EntityDetails entityDetails) throws HttpException, IOException {
        int n2;
        if (this.done.get() || this.responseState.get() != MessageState.HEADERS) {
            throw new ProtocolException("Unexpected message head");
        }
        ProtocolVersion protocolVersion = httpResponse.getVersion();
        if (protocolVersion != null) {
            if (protocolVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException(protocolVersion);
            }
            this.context.setProtocolVersion(protocolVersion);
        }
        if ((n2 = httpResponse.getCode()) < 100) {
            throw new ProtocolException("Invalid response: " + new StatusLine(httpResponse));
        }
        if (n2 > 100 && n2 < 200) {
            this.exchangeHandler.consumeInformation(httpResponse, this.context);
        } else if (!this.connectionReuseStrategy.keepAlive(this.committedRequest, httpResponse, this.context)) {
            this.keepAlive = false;
        }
        if (this.requestState.get() == MessageState.ACK && (n2 == 100 || n2 >= 200)) {
            this.outputChannel.setSocketTimeout(this.timeout);
            this.requestState.set(MessageState.BODY);
            if (n2 < 400) {
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        }
        if (n2 < 200) {
            return;
        }
        if (this.requestState.get() == MessageState.BODY && n2 >= 400) {
            this.requestState.set(MessageState.COMPLETE);
            if (!this.outputChannel.abortGracefully()) {
                this.keepAlive = false;
            }
        }
        this.context.setProtocolVersion(protocolVersion != null ? protocolVersion : HttpVersion.HTTP_1_1);
        this.context.setResponse(httpResponse);
        this.httpProcessor.process(httpResponse, entityDetails, (HttpContext)this.context);
        if (entityDetails == null && !this.keepAlive) {
            this.outputChannel.close();
        }
        this.exchangeHandler.consumeResponse(httpResponse, entityDetails, this.context);
        this.responseState.set(entityDetails == null ? MessageState.COMPLETE : MessageState.BODY);
    }

    void consumeData(ByteBuffer byteBuffer) throws HttpException, IOException {
        if (this.done.get() || this.responseState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        this.exchangeHandler.consume(byteBuffer);
    }

    void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.exchangeHandler.updateCapacity(capacityChannel);
    }

    void dataEnd(List<? extends Header> list) throws HttpException, IOException {
        if (this.done.get() || this.responseState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        this.responseState.set(MessageState.COMPLETE);
        if (!this.keepAlive && this.requestState.get() == MessageState.COMPLETE) {
            this.outputChannel.close();
        }
        this.exchangeHandler.streamEnd(list);
    }

    boolean handleTimeout() {
        if (this.requestState.get() == MessageState.ACK) {
            this.requestState.set(MessageState.BODY);
            this.outputChannel.setSocketTimeout(this.timeout);
            this.outputChannel.requestOutput();
            return true;
        }
        return false;
    }

    void failed(Exception exception) {
        if (!this.done.get()) {
            this.exchangeHandler.failed(exception);
        }
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.responseState.set(MessageState.COMPLETE);
            this.requestState.set(MessageState.COMPLETE);
            this.exchangeHandler.releaseResources();
        }
    }

    void appendState(StringBuilder stringBuilder) {
        stringBuilder.append("requestState=").append((Object)this.requestState.get()).append(", responseState=").append((Object)this.responseState.get()).append(", requestCommitted=").append(this.requestCommitted).append(", keepAlive=").append(this.keepAlive).append(", done=").append(this.done);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        this.appendState(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static /* synthetic */ AtomicReference access$000(ClientHttp1StreamHandler clientHttp1StreamHandler) {
        return clientHttp1StreamHandler.requestState;
    }

    static /* synthetic */ boolean access$100(ClientHttp1StreamHandler clientHttp1StreamHandler) {
        return clientHttp1StreamHandler.keepAlive;
    }

    static /* synthetic */ AtomicReference access$200(ClientHttp1StreamHandler clientHttp1StreamHandler) {
        return clientHttp1StreamHandler.responseState;
    }
}

