/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestFactory;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.RequestHeaderFieldsTooLargeException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.nio.AbstractMessageParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpRequestParser<T extends HttpRequest>
extends AbstractMessageParser<T> {
    private final HttpRequestFactory<T> requestFactory;

    public DefaultHttpRequestParser(Http1Config http1Config, LineParser lineParser, HttpRequestFactory<T> httpRequestFactory) {
        super(http1Config, lineParser);
        this.requestFactory = Args.notNull(httpRequestFactory, "Request factory");
    }

    public DefaultHttpRequestParser(Http1Config http1Config, HttpRequestFactory<T> httpRequestFactory) {
        this(http1Config, null, httpRequestFactory);
    }

    @Deprecated
    public DefaultHttpRequestParser(HttpRequestFactory<T> httpRequestFactory, Http1Config http1Config) {
        this(httpRequestFactory, null, http1Config);
    }

    @Deprecated
    public DefaultHttpRequestParser(HttpRequestFactory<T> httpRequestFactory, LineParser lineParser, Http1Config http1Config) {
        this(http1Config, lineParser, httpRequestFactory);
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> httpRequestFactory) {
        this(null, null, httpRequestFactory);
    }

    @Override
    public T parse(SessionInputBuffer sessionInputBuffer, boolean bl2) throws IOException, HttpException {
        try {
            return (T)((HttpRequest)super.parse(sessionInputBuffer, bl2));
        }
        catch (MessageConstraintException messageConstraintException) {
            throw new RequestHeaderFieldsTooLargeException(messageConstraintException.getMessage(), messageConstraintException);
        }
    }

    @Override
    protected T createMessage(CharArrayBuffer serializable) throws HttpException {
        serializable = this.getLineParser().parseRequestLine((CharArrayBuffer)serializable);
        T t2 = this.requestFactory.newHttpRequest(((RequestLine)serializable).getMethod(), ((RequestLine)serializable).getUri());
        t2.setVersion(((RequestLine)serializable).getProtocolVersion());
        return t2;
    }
}

