/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.nio.AbstractMessageParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpResponseParser<T extends HttpResponse>
extends AbstractMessageParser<T> {
    private final HttpResponseFactory<T> responseFactory;

    public DefaultHttpResponseParser(Http1Config http1Config, LineParser lineParser, HttpResponseFactory<T> httpResponseFactory) {
        super(http1Config, lineParser);
        this.responseFactory = Args.notNull(httpResponseFactory, "Response factory");
    }

    public DefaultHttpResponseParser(Http1Config http1Config, HttpResponseFactory<T> httpResponseFactory) {
        this(http1Config, null, httpResponseFactory);
    }

    @Deprecated
    public DefaultHttpResponseParser(HttpResponseFactory<T> httpResponseFactory, LineParser lineParser, Http1Config http1Config) {
        this(http1Config, lineParser, httpResponseFactory);
    }

    @Deprecated
    public DefaultHttpResponseParser(HttpResponseFactory<T> httpResponseFactory, Http1Config http1Config) {
        this(httpResponseFactory, null, http1Config);
    }

    public DefaultHttpResponseParser(HttpResponseFactory<T> httpResponseFactory) {
        this(null, null, httpResponseFactory);
    }

    @Override
    protected T createMessage(CharArrayBuffer serializable) throws HttpException {
        serializable = this.getLineParser().parseStatusLine((CharArrayBuffer)serializable);
        T t2 = this.responseFactory.newHttpResponse(((StatusLine)serializable).getStatusCode(), ((StatusLine)serializable).getReasonPhrase());
        t2.setVersion(((StatusLine)serializable).getProtocolVersion());
        return t2;
    }
}

