/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.impl.nio.ExpandableBuffer$Mode;

@Internal
public class ExpandableBuffer {
    private ExpandableBuffer$Mode mode;
    private ByteBuffer buffer;

    protected ExpandableBuffer(int n2) {
        this.buffer = ByteBuffer.allocate(n2);
        this.mode = ExpandableBuffer$Mode.INPUT;
    }

    protected ExpandableBuffer$Mode mode() {
        return this.mode;
    }

    protected ByteBuffer buffer() {
        return this.buffer;
    }

    protected void setOutputMode() {
        if (this.mode != ExpandableBuffer$Mode.OUTPUT) {
            this.buffer.flip();
            this.mode = ExpandableBuffer$Mode.OUTPUT;
        }
    }

    protected void setInputMode() {
        if (this.mode != ExpandableBuffer$Mode.INPUT) {
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
            this.mode = ExpandableBuffer$Mode.INPUT;
        }
    }

    private void expandCapacity(int n2) {
        ByteBuffer byteBuffer = this.buffer;
        this.buffer = ByteBuffer.allocate(n2);
        byteBuffer.flip();
        this.buffer.put(byteBuffer);
    }

    protected void expand() throws BufferOverflowException {
        int n2 = this.buffer.capacity() + 1 << 1;
        if (n2 < 0) {
            n2 = Math.max(8, 8);
            if ((n2 = Integer.MAX_VALUE - n2) <= this.buffer.capacity()) {
                throw new BufferOverflowException();
            }
        }
        this.expandCapacity(n2);
    }

    protected void ensureCapacity(int n2) {
        if (n2 > this.buffer.capacity()) {
            this.expandCapacity(n2);
        }
    }

    protected void ensureAdjustedCapacity(int n2) {
        if (n2 > this.buffer.capacity()) {
            n2 = (n2 >> 10) + 1 << 10;
            this.expandCapacity(n2);
        }
    }

    protected boolean hasData() {
        this.setOutputMode();
        return this.buffer.hasRemaining();
    }

    protected int length() {
        this.setOutputMode();
        return this.buffer.remaining();
    }

    protected int capacity() {
        this.setInputMode();
        return this.buffer.remaining();
    }

    protected void clear() {
        this.buffer.clear();
        this.mode = ExpandableBuffer$Mode.INPUT;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[mode=");
        stringBuilder.append((Object)this.mode);
        stringBuilder.append(" pos=");
        stringBuilder.append(this.buffer.position());
        stringBuilder.append(" lim=");
        stringBuilder.append(this.buffer.limit());
        stringBuilder.append(" cap=");
        stringBuilder.append(this.buffer.capacity());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

