/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.AbstractContentEncoder;
import org.apache.hc.core5.http.nio.FileContentEncoder;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;

public class IdentityEncoder
extends AbstractContentEncoder
implements FileContentEncoder {
    private final int fragHint;

    public IdentityEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics, int n2) {
        super(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics);
        this.fragHint = Math.max(n2, 0);
    }

    public IdentityEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) {
        this(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics, 0);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return 0;
        }
        this.assertNotCompleted();
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            int n3;
            if ((this.buffer.hasData() || this.fragHint > 0) && byteBuffer.remaining() <= this.fragHint && (n3 = this.fragHint - this.buffer.length()) > 0) {
                n3 = Math.min(n3, byteBuffer.remaining());
                n3 = this.writeToBuffer(byteBuffer, n3);
                n2 += n3;
            }
            if (this.buffer.hasData() && (this.buffer.length() >= this.fragHint || byteBuffer.hasRemaining()) && (n3 = this.flushToChannel()) == 0) break;
            if (this.buffer.hasData() || byteBuffer.remaining() <= this.fragHint) continue;
            n3 = this.writeToChannel(byteBuffer);
            n2 += n3;
            if (n3 != 0) continue;
        }
        return n2;
    }

    @Override
    public long transfer(FileChannel fileChannel, long l2, long l3) throws IOException {
        if (fileChannel == null) {
            return 0L;
        }
        this.assertNotCompleted();
        this.flushToChannel();
        if (this.buffer.hasData()) {
            return 0L;
        }
        long l4 = fileChannel.transferTo(l2, l3, this.channel);
        if (l4 > 0L) {
            this.metrics.incrementBytesTransferred(l4);
        }
        return l4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[identity; completed: ");
        stringBuilder.append(this.isCompleted());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

