/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.AbstractContentEncoder;
import org.apache.hc.core5.http.nio.FileContentEncoder;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.util.Args;

public class LengthDelimitedEncoder
extends AbstractContentEncoder
implements FileContentEncoder {
    private final long contentLength;
    private final int fragHint;
    private long remaining;

    public LengthDelimitedEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics, long l2, int n2) {
        super(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics);
        Args.notNegative(l2, "Content length");
        this.contentLength = l2;
        this.fragHint = Math.max(n2, 0);
        this.remaining = l2;
    }

    public LengthDelimitedEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics, long l2) {
        this(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics, l2, 0);
    }

    private int nextChunk(ByteBuffer byteBuffer) {
        return (int)Math.min(Math.min(this.remaining, Integer.MAX_VALUE), (long)byteBuffer.remaining());
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return 0;
        }
        this.assertNotCompleted();
        int n2 = 0;
        while (byteBuffer.hasRemaining() && this.remaining > 0L) {
            int n3;
            int n4;
            if ((this.buffer.hasData() || this.fragHint > 0) && (n4 = this.nextChunk(byteBuffer)) <= this.fragHint && (n3 = this.fragHint - this.buffer.length()) > 0) {
                n4 = Math.min(n3, n4);
                n4 = this.writeToBuffer(byteBuffer, n4);
                this.remaining -= (long)n4;
                n2 += n4;
            }
            if (this.buffer.hasData()) {
                n4 = this.nextChunk(byteBuffer);
                if ((this.buffer.length() >= this.fragHint || n4 > 0) && (n3 = this.flushToChannel()) == 0) break;
            }
            if (this.buffer.hasData() || (n4 = this.nextChunk(byteBuffer)) <= this.fragHint) continue;
            n3 = this.writeToChannel(byteBuffer, n4);
            this.remaining -= (long)n3;
            n2 += n3;
            if (n3 != 0) continue;
        }
        if (this.remaining <= 0L) {
            super.complete(null);
        }
        return n2;
    }

    @Override
    public long transfer(FileChannel fileChannel, long l2, long l3) throws IOException {
        if (fileChannel == null) {
            return 0L;
        }
        this.assertNotCompleted();
        this.flushToChannel();
        if (this.buffer.hasData()) {
            return 0L;
        }
        long l4 = Math.min(this.remaining, l3);
        long l5 = fileChannel.transferTo(l2, l4, this.channel);
        if (l5 > 0L) {
            this.metrics.incrementBytesTransferred(l5);
        }
        this.remaining -= l5;
        if (this.remaining <= 0L) {
            super.complete(null);
        }
        return l5;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[content length: ");
        stringBuilder.append(this.contentLength);
        stringBuilder.append("; pos: ");
        stringBuilder.append(this.contentLength - this.remaining);
        stringBuilder.append("; completed: ");
        stringBuilder.append(this.isCompleted());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

