/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.nio.FlushMode;
import org.apache.hc.core5.http.impl.nio.Http1StreamChannel;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexer$1;
import org.apache.hc.core5.util.Timeout;

class ServerHttp1StreamDuplexer$DelayedOutputChannel
implements Http1StreamChannel<HttpResponse> {
    private final Http1StreamChannel<HttpResponse> channel;
    private volatile boolean direct;
    private volatile HttpResponse delayedResponse;
    private volatile boolean completed;
    private final ReentrantLock lock = new ReentrantLock();

    private ServerHttp1StreamDuplexer$DelayedOutputChannel(Http1StreamChannel<HttpResponse> http1StreamChannel) {
        this.channel = http1StreamChannel;
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public void submit(HttpResponse httpResponse, boolean bl2, FlushMode flushMode) throws HttpException, IOException {
        this.lock.lock();
        try {
            if (this.direct) {
                this.channel.submit(httpResponse, bl2, flushMode);
            } else {
                this.delayedResponse = httpResponse;
                this.completed = bl2;
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void suspendOutput() throws IOException {
        this.channel.suspendOutput();
    }

    @Override
    public void requestOutput() {
        this.channel.requestOutput();
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.channel.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.channel.setSocketTimeout(timeout);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.lock.lock();
        try {
            int n2 = this.direct ? this.channel.write(byteBuffer) : 0;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void complete(List<? extends Header> list) throws IOException {
        this.lock.lock();
        try {
            if (this.direct) {
                this.channel.complete(list);
            } else {
                this.completed = true;
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean abortGracefully() throws IOException {
        this.lock.lock();
        try {
            if (this.direct) {
                boolean bl2 = this.channel.abortGracefully();
                return bl2;
            }
            this.completed = true;
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isCompleted() {
        this.lock.lock();
        try {
            boolean bl2 = this.direct ? this.channel.isCompleted() : this.completed;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void activate() throws IOException, HttpException {
        this.lock.lock();
        try {
            this.direct = true;
            if (this.delayedResponse != null) {
                this.channel.submit(this.delayedResponse, this.completed, this.completed ? FlushMode.IMMEDIATE : FlushMode.BUFFER);
                this.delayedResponse = null;
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /* synthetic */ ServerHttp1StreamDuplexer$DelayedOutputChannel(Http1StreamChannel http1StreamChannel, ServerHttp1StreamDuplexer$1 serverHttp1StreamDuplexer$1) {
        this(http1StreamChannel);
    }
}

