/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.nio.AbstractHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.ChunkDecoder;
import org.apache.hc.core5.http.impl.nio.ChunkEncoder;
import org.apache.hc.core5.http.impl.nio.Http1StreamChannel;
import org.apache.hc.core5.http.impl.nio.IdentityEncoder;
import org.apache.hc.core5.http.impl.nio.LengthDelimitedDecoder;
import org.apache.hc.core5.http.impl.nio.LengthDelimitedEncoder;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexer$1;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexer$DelayedOutputChannel;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamHandler;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.ContentDecoder;
import org.apache.hc.core5.http.nio.ContentEncoder;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.NHttpMessageParser;
import org.apache.hc.core5.http.nio.NHttpMessageWriter;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

@Internal
public class ServerHttp1StreamDuplexer
extends AbstractHttp1StreamDuplexer<HttpRequest, HttpResponse> {
    private final String scheme;
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final Http1Config http1Config;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final Http1StreamListener streamListener;
    private final Callback<Exception> exceptionCallback;
    private final Queue<ServerHttp1StreamHandler> pipeline;
    private final Http1StreamChannel<HttpResponse> outputChannel;
    private volatile ServerHttp1StreamHandler outgoing;
    private volatile ServerHttp1StreamHandler incoming;

    public ServerHttp1StreamDuplexer(ProtocolIOSession protocolIOSession, HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> handlerFactory, String string, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParser<HttpRequest> nHttpMessageParser, NHttpMessageWriter<HttpResponse> nHttpMessageWriter, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, Http1StreamListener http1StreamListener, Callback<Exception> callback) {
        super(protocolIOSession, http1Config, charCodingConfig, nHttpMessageParser, nHttpMessageWriter, contentLengthStrategy, contentLengthStrategy2);
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.exchangeHandlerFactory = Args.notNull(handlerFactory, "Exchange handler factory");
        this.scheme = string != null ? string : URIScheme.HTTP.getId();
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.streamListener = http1StreamListener;
        this.exceptionCallback = callback;
        this.pipeline = new ConcurrentLinkedQueue<ServerHttp1StreamHandler>();
        this.outputChannel = new ServerHttp1StreamDuplexer$1(this, http1StreamListener);
    }

    @Override
    void terminate(Exception exception) {
        ServerHttp1StreamHandler serverHttp1StreamHandler;
        if (this.incoming != null) {
            this.incoming.failed(exception);
            this.incoming.releaseResources();
            this.incoming = null;
        }
        if (this.outgoing != null) {
            this.outgoing.failed(exception);
            this.outgoing.releaseResources();
            this.outgoing = null;
        }
        while ((serverHttp1StreamHandler = this.pipeline.poll()) != null) {
            serverHttp1StreamHandler.failed(exception);
            serverHttp1StreamHandler.releaseResources();
        }
    }

    @Override
    void disconnected() {
        ServerHttp1StreamHandler serverHttp1StreamHandler;
        if (this.incoming != null) {
            if (!this.incoming.isCompleted()) {
                this.incoming.failed(new ConnectionClosedException());
            }
            this.incoming.releaseResources();
            this.incoming = null;
        }
        if (this.outgoing != null) {
            if (!this.outgoing.isCompleted()) {
                this.outgoing.failed(new ConnectionClosedException());
            }
            this.outgoing.releaseResources();
            this.outgoing = null;
        }
        while ((serverHttp1StreamHandler = this.pipeline.poll()) != null) {
            serverHttp1StreamHandler.failed(new ConnectionClosedException());
            serverHttp1StreamHandler.releaseResources();
        }
    }

    @Override
    void updateInputMetrics(HttpRequest httpRequest, BasicHttpConnectionMetrics basicHttpConnectionMetrics) {
        basicHttpConnectionMetrics.incrementRequestCount();
    }

    @Override
    void updateOutputMetrics(HttpResponse httpResponse, BasicHttpConnectionMetrics basicHttpConnectionMetrics) {
        if (httpResponse.getCode() >= 200) {
            basicHttpConnectionMetrics.incrementResponseCount();
        }
    }

    @Override
    protected boolean handleIncomingMessage(HttpRequest httpRequest) throws HttpException {
        return true;
    }

    @Override
    protected ContentDecoder createContentDecoder(long l2, ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) throws HttpException {
        if (l2 >= 0L) {
            return new LengthDelimitedDecoder(readableByteChannel, sessionInputBuffer, basicHttpTransportMetrics, l2);
        }
        if (l2 == -1L) {
            return new ChunkDecoder(readableByteChannel, sessionInputBuffer, this.http1Config, basicHttpTransportMetrics);
        }
        return null;
    }

    @Override
    protected boolean handleOutgoingMessage(HttpResponse httpResponse) throws HttpException {
        return true;
    }

    @Override
    protected ContentEncoder createContentEncoder(long l2, WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) throws HttpException {
        int n2;
        int n3 = n2 = this.http1Config.getChunkSizeHint() >= 0 ? this.http1Config.getChunkSizeHint() : 2048;
        if (l2 >= 0L) {
            return new LengthDelimitedEncoder(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics, l2, n2);
        }
        if (l2 == -1L) {
            return new ChunkEncoder(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics, n2);
        }
        return new IdentityEncoder(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics, n2);
    }

    @Override
    boolean inputIdle() {
        return this.incoming == null;
    }

    @Override
    boolean outputIdle() {
        return this.outgoing == null && this.pipeline.isEmpty();
    }

    @Override
    HttpRequest parseMessageHead(boolean bl2) throws IOException, HttpException {
        try {
            return (HttpRequest)super.parseMessageHead(bl2);
        }
        catch (HttpException httpException) {
            this.terminateExchange(httpException);
            return null;
        }
    }

    void terminateExchange(HttpException httpException) throws HttpException, IOException {
        this.suspendSessionInput();
        Object object = HttpCoreContext.create();
        ((HttpCoreContext)object).setSSLSession(this.getSSLSession());
        ((HttpCoreContext)object).setEndpointDetails(this.getEndpointDetails());
        if (this.outgoing == null) {
            this.outgoing = object = new ServerHttp1StreamHandler(this.outputChannel, this.httpProcessor, this.http1Config, this.connectionReuseStrategy, this.exchangeHandlerFactory, this.exceptionCallback, (HttpCoreContext)object);
        } else {
            object = new ServerHttp1StreamHandler(new ServerHttp1StreamDuplexer$DelayedOutputChannel(this.outputChannel, null), this.httpProcessor, this.http1Config, this.connectionReuseStrategy, this.exchangeHandlerFactory, this.exceptionCallback, (HttpCoreContext)object);
            this.pipeline.add((ServerHttp1StreamHandler)object);
        }
        ((ServerHttp1StreamHandler)object).terminateExchange(httpException);
        this.incoming = null;
    }

    @Override
    void consumeHeader(HttpRequest httpRequest, EntityDetails entityDetails) throws HttpException, IOException {
        if (this.streamListener != null) {
            this.streamListener.onRequestHead(this, httpRequest);
        }
        Object object = HttpCoreContext.create();
        ((HttpCoreContext)object).setSSLSession(this.getSSLSession());
        ((HttpCoreContext)object).setEndpointDetails(this.getEndpointDetails());
        if (this.outgoing == null) {
            this.outgoing = object = new ServerHttp1StreamHandler(this.outputChannel, this.httpProcessor, this.http1Config, this.connectionReuseStrategy, this.exchangeHandlerFactory, this.exceptionCallback, (HttpCoreContext)object);
        } else {
            object = new ServerHttp1StreamHandler(new ServerHttp1StreamDuplexer$DelayedOutputChannel(this.outputChannel, null), this.httpProcessor, this.http1Config, this.connectionReuseStrategy, this.exchangeHandlerFactory, this.exceptionCallback, (HttpCoreContext)object);
            this.pipeline.add((ServerHttp1StreamHandler)object);
        }
        httpRequest.setScheme(this.scheme);
        ((ServerHttp1StreamHandler)object).consumeHeader(httpRequest, entityDetails);
        this.incoming = object;
    }

    @Override
    void consumeData(ByteBuffer byteBuffer) throws HttpException, IOException {
        Asserts.notNull(this.incoming, "Request stream handler");
        this.incoming.consumeData(byteBuffer);
    }

    @Override
    void updateCapacity(CapacityChannel capacityChannel) throws HttpException, IOException {
        Asserts.notNull(this.incoming, "Request stream handler");
        this.incoming.updateCapacity(capacityChannel);
    }

    @Override
    void dataEnd(List<? extends Header> list) throws HttpException, IOException {
        Asserts.notNull(this.incoming, "Request stream handler");
        this.incoming.dataEnd(list);
    }

    @Override
    void inputEnd() throws HttpException, IOException {
        if (this.incoming != null) {
            if (this.incoming.isCompleted()) {
                this.incoming.releaseResources();
            }
            this.incoming = null;
        }
        if (this.isShuttingDown() && this.outputIdle() && this.inputIdle()) {
            this.shutdownSession(CloseMode.IMMEDIATE);
        }
    }

    @Override
    void execute(RequestExecutionCommand requestExecutionCommand) throws HttpException {
        throw new HttpException("Illegal command: " + requestExecutionCommand.getClass());
    }

    @Override
    boolean isRequestInitiated() {
        return false;
    }

    @Override
    boolean isOutputReady() {
        return this.outgoing != null && this.outgoing.isOutputReady();
    }

    @Override
    void produceOutput() throws HttpException, IOException {
        if (this.outgoing != null) {
            this.outgoing.produceOutput();
        }
    }

    @Override
    void outputEnd() throws HttpException, IOException {
        ServerHttp1StreamHandler serverHttp1StreamHandler;
        if (this.outgoing != null && this.outgoing.isResponseFinal()) {
            if (this.streamListener != null) {
                ServerHttp1StreamDuplexer serverHttp1StreamDuplexer = this;
                this.streamListener.onExchangeComplete(serverHttp1StreamDuplexer, serverHttp1StreamDuplexer.outgoing.keepAlive());
            }
            if (this.outgoing.isCompleted()) {
                this.outgoing.releaseResources();
            }
            this.outgoing = null;
        }
        if (this.outgoing == null && this.isActive() && (serverHttp1StreamHandler = this.pipeline.poll()) != null) {
            this.outgoing = serverHttp1StreamHandler;
            serverHttp1StreamHandler.activateChannel();
            if (serverHttp1StreamHandler.isOutputReady()) {
                serverHttp1StreamHandler.produceOutput();
            }
        }
        if (this.isShuttingDown() && this.outputIdle() && this.inputIdle()) {
            this.shutdownSession(CloseMode.IMMEDIATE);
        }
    }

    @Override
    boolean handleTimeout() {
        return false;
    }

    @Override
    void appendState(StringBuilder stringBuilder) {
        super.appendState(stringBuilder);
        stringBuilder.append(", incoming=[");
        if (this.incoming != null) {
            this.incoming.appendState(stringBuilder);
        }
        stringBuilder.append("], outgoing=[");
        if (this.outgoing != null) {
            this.outgoing.appendState(stringBuilder);
        }
        stringBuilder.append("], pipeline=");
        stringBuilder.append(this.pipeline.size());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        this.appendState(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

