/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.nio.DefaultHttpRequestParserFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpResponseWriterFactory;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.NHttpMessageParserFactory;
import org.apache.hc.core5.http.nio.NHttpMessageWriterFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public final class ServerHttp1StreamDuplexerFactory {
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final Http1Config http1Config;
    private final CharCodingConfig charCodingConfig;
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final NHttpMessageWriterFactory<HttpResponse> responseWriterFactory;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final Http1StreamListener streamListener;
    private final Callback<Exception> exceptionCallback;

    public ServerHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> handlerFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpRequest> defaultHttpRequestParserFactory, NHttpMessageWriterFactory<HttpResponse> defaultHttpResponseWriterFactory, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, Http1StreamListener http1StreamListener, Callback<Exception> callback) {
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.exchangeHandlerFactory = Args.notNull(handlerFactory, "Exchange handler factory");
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.requestParserFactory = defaultHttpRequestParserFactory != null ? defaultHttpRequestParserFactory : new DefaultHttpRequestParserFactory(this.http1Config);
        this.responseWriterFactory = defaultHttpResponseWriterFactory != null ? defaultHttpResponseWriterFactory : new DefaultHttpResponseWriterFactory(this.http1Config);
        this.incomingContentStrategy = contentLengthStrategy != null ? contentLengthStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = contentLengthStrategy2 != null ? contentLengthStrategy2 : DefaultContentLengthStrategy.INSTANCE;
        this.streamListener = http1StreamListener;
        this.exceptionCallback = callback;
    }

    public ServerHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> handlerFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpRequest> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpResponse> nHttpMessageWriterFactory, Http1StreamListener http1StreamListener, Callback<Exception> callback) {
        this(httpProcessor, handlerFactory, http1Config, charCodingConfig, connectionReuseStrategy, nHttpMessageParserFactory, nHttpMessageWriterFactory, null, null, http1StreamListener, callback);
    }

    public ServerHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> handlerFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, Http1StreamListener http1StreamListener, Callback<Exception> callback) {
        this(httpProcessor, handlerFactory, http1Config, charCodingConfig, null, null, null, http1StreamListener, callback);
    }

    public final ServerHttp1StreamDuplexer create(String string, ProtocolIOSession protocolIOSession) {
        return new ServerHttp1StreamDuplexer(protocolIOSession, this.httpProcessor, this.exchangeHandlerFactory, string, this.http1Config, this.charCodingConfig, this.connectionReuseStrategy, this.requestParserFactory.create(), this.responseWriterFactory.create(), this.incomingContentStrategy, this.outgoingContentStrategy, this.streamListener, this.exceptionCallback);
    }
}

