/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.MisdirectedRequestException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.ServerSupport;
import org.apache.hc.core5.http.impl.nio.FlushMode;
import org.apache.hc.core5.http.impl.nio.Http1StreamChannel;
import org.apache.hc.core5.http.impl.nio.MessageState;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamHandler$1;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamHandler$2;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.ResourceHolder;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.support.BasicResponseProducer;
import org.apache.hc.core5.http.nio.support.ImmediateResponseExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;

class ServerHttp1StreamHandler
implements ResourceHolder {
    private final Http1StreamChannel<HttpResponse> outputChannel;
    private final DataStreamChannel internalDataChannel;
    private final ResponseChannel responseChannel;
    private final HttpProcessor httpProcessor;
    private final Http1Config http1Config;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final Callback<Exception> exceptionCallback;
    private final HttpCoreContext context;
    private final AtomicReference<MessageState> requestState;
    private final AtomicReference<MessageState> responseState;
    private final AtomicBoolean responseCommitted;
    private final AtomicBoolean done;
    private volatile boolean keepAlive;
    private volatile AsyncServerExchangeHandler exchangeHandler;
    private volatile HttpRequest receivedRequest;

    ServerHttp1StreamHandler(Http1StreamChannel<HttpResponse> http1StreamChannel, HttpProcessor httpProcessor, Http1Config http1Config, ConnectionReuseStrategy connectionReuseStrategy, HandlerFactory<AsyncServerExchangeHandler> handlerFactory, Callback<Exception> callback, HttpCoreContext httpCoreContext) {
        this.outputChannel = http1StreamChannel;
        this.internalDataChannel = new ServerHttp1StreamHandler$1(this, http1StreamChannel);
        this.responseChannel = new ServerHttp1StreamHandler$2(this);
        this.httpProcessor = httpProcessor;
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy;
        this.exchangeHandlerFactory = handlerFactory;
        this.exceptionCallback = callback;
        this.context = httpCoreContext;
        this.requestState = new AtomicReference<MessageState>(MessageState.HEADERS);
        this.responseState = new AtomicReference<MessageState>(MessageState.IDLE);
        this.responseCommitted = new AtomicBoolean();
        this.done = new AtomicBoolean();
        this.keepAlive = true;
    }

    private void commitResponse(HttpResponse httpResponse, EntityDetails entityDetails) throws HttpException, IOException {
        block8: {
            block5: {
                block7: {
                    block6: {
                        boolean bl2;
                        int n2;
                        if (!this.responseCommitted.compareAndSet(false, true)) break block5;
                        ProtocolVersion protocolVersion = httpResponse.getVersion();
                        if (protocolVersion != null) {
                            if (!protocolVersion.lessEquals(this.http1Config.getVersion())) {
                                throw new UnsupportedHttpVersionException(protocolVersion);
                            }
                            this.context.setProtocolVersion(protocolVersion);
                        }
                        if ((n2 = httpResponse.getCode()) < 200) {
                            throw new HttpException("Invalid response: " + n2);
                        }
                        this.context.setResponse(httpResponse);
                        this.httpProcessor.process(httpResponse, entityDetails, (HttpContext)this.context);
                        boolean bl3 = bl2 = entityDetails == null || this.receivedRequest != null && Method.HEAD.isSame(this.receivedRequest.getMethod());
                        if (!this.connectionReuseStrategy.keepAlive(this.receivedRequest, httpResponse, this.context)) {
                            this.keepAlive = false;
                        }
                        if (!bl2) break block6;
                        this.responseState.set(MessageState.COMPLETE);
                        this.outputChannel.submit(httpResponse, true, FlushMode.IMMEDIATE);
                        if (this.keepAlive) break block7;
                        break block8;
                    }
                    this.outputChannel.submit(httpResponse, false, FlushMode.BUFFER);
                    this.exchangeHandler.produce(this.internalDataChannel);
                    if (this.responseState.compareAndSet(MessageState.IDLE, MessageState.BODY)) {
                        this.outputChannel.requestOutput();
                    }
                }
                return;
            }
            throw new HttpException("Response already committed");
        }
        this.outputChannel.close();
    }

    private void commitInformation(HttpResponse httpResponse) throws IOException, HttpException {
        if (this.responseCommitted.get()) {
            throw new HttpException("Response already committed");
        }
        int n2 = httpResponse.getCode();
        if (n2 < 100 || n2 >= 200) {
            throw new HttpException("Invalid intermediate response: " + n2);
        }
        this.outputChannel.submit(httpResponse, true, FlushMode.IMMEDIATE);
    }

    private void commitPromise() throws HttpException {
        throw new HttpException("HTTP/1.1 does not support server push");
    }

    void activateChannel() throws IOException, HttpException {
        this.outputChannel.activate();
    }

    boolean isResponseFinal() {
        return this.responseState.get() == MessageState.COMPLETE;
    }

    boolean keepAlive() {
        return this.keepAlive;
    }

    boolean isCompleted() {
        return this.requestState.get() == MessageState.COMPLETE && this.responseState.get() == MessageState.COMPLETE;
    }

    void terminateExchange(HttpException object) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.HEADERS) {
            throw new ProtocolException("Unexpected message head");
        }
        this.receivedRequest = null;
        this.requestState.set(MessageState.COMPLETE);
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(ServerSupport.toStatusCode((Exception)object));
        basicHttpResponse.addHeader("Connection", "close");
        object = new BasicResponseProducer((HttpResponse)basicHttpResponse, ServerSupport.toErrorMessage((Exception)object));
        this.exchangeHandler = new ImmediateResponseExchangeHandler((AsyncResponseProducer)object);
        this.exchangeHandler.handleRequest(null, null, this.responseChannel, this.context);
    }

    void consumeHeader(HttpRequest httpRequest, EntityDetails entityDetails) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.HEADERS) {
            throw new ProtocolException("Unexpected message head");
        }
        this.receivedRequest = httpRequest;
        this.requestState.set(entityDetails == null ? MessageState.COMPLETE : MessageState.BODY);
        try {
            AsyncServerExchangeHandler asyncServerExchangeHandler;
            ProtocolVersion protocolVersion = httpRequest.getVersion();
            if (protocolVersion != null && protocolVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException(protocolVersion);
            }
            this.context.setProtocolVersion(protocolVersion != null ? protocolVersion : this.http1Config.getVersion());
            this.context.setRequest(httpRequest);
            this.httpProcessor.process(httpRequest, entityDetails, (HttpContext)this.context);
            try {
                asyncServerExchangeHandler = this.exchangeHandlerFactory.create(httpRequest, this.context);
            }
            catch (MisdirectedRequestException misdirectedRequestException) {
                asyncServerExchangeHandler = new ImmediateResponseExchangeHandler(421, misdirectedRequestException.getMessage());
            }
            catch (HttpException httpException) {
                asyncServerExchangeHandler = new ImmediateResponseExchangeHandler(500, httpException.getMessage());
            }
            if (asyncServerExchangeHandler == null) {
                asyncServerExchangeHandler = new ImmediateResponseExchangeHandler(404, "Cannot handle request");
            }
            this.exchangeHandler = asyncServerExchangeHandler;
            this.exchangeHandler.handleRequest(httpRequest, entityDetails, this.responseChannel, this.context);
            return;
        }
        catch (HttpException httpException) {
            if (!this.responseCommitted.get()) {
                BasicHttpResponse basicHttpResponse = new BasicHttpResponse(ServerSupport.toStatusCode(httpException));
                basicHttpResponse.addHeader("Connection", "close");
                BasicResponseProducer basicResponseProducer = new BasicResponseProducer((HttpResponse)basicHttpResponse, ServerSupport.toErrorMessage(httpException));
                this.exchangeHandler = new ImmediateResponseExchangeHandler(basicResponseProducer);
                this.exchangeHandler.handleRequest(httpRequest, entityDetails, this.responseChannel, this.context);
                return;
            }
            throw httpException;
        }
    }

    boolean isOutputReady() {
        switch (this.responseState.get()) {
            case BODY: {
                return this.exchangeHandler.available() > 0;
            }
        }
        return false;
    }

    void produceOutput() throws IOException {
        switch (this.responseState.get()) {
            case BODY: {
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        }
    }

    void consumeData(ByteBuffer byteBuffer) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        if (this.responseState.get() == MessageState.ACK) {
            this.outputChannel.requestOutput();
        }
        this.exchangeHandler.consume(byteBuffer);
    }

    void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.exchangeHandler.updateCapacity(capacityChannel);
    }

    void dataEnd(List<? extends Header> list) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        this.requestState.set(MessageState.COMPLETE);
        if (this.responseState.get() == MessageState.COMPLETE && !this.keepAlive) {
            this.outputChannel.close();
        }
        this.exchangeHandler.streamEnd(list);
    }

    void failed(Exception exception) {
        if (!this.done.get() && this.exchangeHandler != null) {
            this.exchangeHandler.failed(exception);
            return;
        }
        if (this.exceptionCallback != null) {
            this.exceptionCallback.execute(exception);
        }
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.requestState.set(MessageState.COMPLETE);
            this.responseState.set(MessageState.COMPLETE);
            if (this.exchangeHandler != null) {
                this.exchangeHandler.releaseResources();
            }
        }
    }

    void appendState(StringBuilder stringBuilder) {
        stringBuilder.append("requestState=").append((Object)this.requestState.get()).append(", responseState=").append((Object)this.responseState.get()).append(", responseCommitted=").append(this.responseCommitted).append(", keepAlive=").append(this.keepAlive).append(", done=").append(this.done);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        this.appendState(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static /* synthetic */ AtomicReference access$000(ServerHttp1StreamHandler serverHttp1StreamHandler) {
        return serverHttp1StreamHandler.responseState;
    }

    static /* synthetic */ AtomicReference access$100(ServerHttp1StreamHandler serverHttp1StreamHandler) {
        return serverHttp1StreamHandler.requestState;
    }

    static /* synthetic */ boolean access$200(ServerHttp1StreamHandler serverHttp1StreamHandler) {
        return serverHttp1StreamHandler.keepAlive;
    }

    static /* synthetic */ void access$300(ServerHttp1StreamHandler serverHttp1StreamHandler, HttpResponse httpResponse) throws IOException, HttpException {
        serverHttp1StreamHandler.commitInformation(httpResponse);
    }

    static /* synthetic */ void access$400(ServerHttp1StreamHandler serverHttp1StreamHandler, HttpResponse httpResponse, EntityDetails entityDetails) throws HttpException, IOException {
        serverHttp1StreamHandler.commitResponse(httpResponse, entityDetails);
    }

    static /* synthetic */ void access$500(ServerHttp1StreamHandler serverHttp1StreamHandler) throws HttpException {
        serverHttp1StreamHandler.commitPromise();
    }
}

