/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.impl.routing.RequestRouter$Entry;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

public class RequestRouter$Builder<T> {
    private final UriPatternType patternType;
    private final List<RequestRouter$Entry<T>> handlerEntries;
    private BiFunction<String, URIAuthority, URIAuthority> authorityResolver;
    private HttpRequestMapper<T> downstream;

    RequestRouter$Builder(UriPatternType uriPatternType) {
        this.patternType = uriPatternType != null ? uriPatternType : UriPatternType.URI_PATTERN;
        this.handlerEntries = new ArrayList<RequestRouter$Entry<T>>();
    }

    public RequestRouter$Builder<T> addRoute(URIAuthority uRIAuthority, String string, T t2) {
        Args.notNull(uRIAuthority, "URI authority");
        Args.notBlank(string, "URI path pattern");
        Args.notNull(t2, "Handler");
        this.handlerEntries.add(new RequestRouter$Entry<T>(uRIAuthority, string, t2));
        return this;
    }

    public RequestRouter$Builder<T> addRoute(String string, String string2, T t2) {
        Args.notBlank(string, "Hostname");
        Args.notBlank(string2, "URI path pattern");
        Args.notNull(t2, "Handler");
        this.handlerEntries.add(new RequestRouter$Entry<T>(string, string2, t2));
        return this;
    }

    public RequestRouter$Builder<T> resolveAuthority(BiFunction<String, URIAuthority, URIAuthority> biFunction) {
        this.authorityResolver = biFunction;
        return this;
    }

    public RequestRouter$Builder<T> downstream(HttpRequestMapper<T> httpRequestMapper) {
        this.downstream = httpRequestMapper;
        return this;
    }

    public RequestRouter<T> build() {
        return RequestRouter.create(null, this.patternType, this.handlerEntries, this.authorityResolver, this.downstream);
    }
}

