/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.routing;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.MisdirectedRequestException;
import org.apache.hc.core5.http.impl.routing.RequestRouter$Builder;
import org.apache.hc.core5.http.impl.routing.RequestRouter$Entry;
import org.apache.hc.core5.http.impl.routing.RequestRouter$NoAuthorityResolver;
import org.apache.hc.core5.http.impl.routing.RequestRouter$SingleAuthorityResolver;
import org.apache.hc.core5.http.impl.routing.UriPathRouter;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.net.URIAuthority;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestRouter<T>
implements HttpRequestMapper<T> {
    public static final URIAuthority LOCAL_AUTHORITY = new URIAuthority("localhost");
    public static final BiFunction<String, URIAuthority, URIAuthority> LOCAL_AUTHORITY_RESOLVER = (string, uRIAuthority) -> LOCAL_AUTHORITY;
    public static final BiFunction<String, URIAuthority, URIAuthority> IGNORE_PORT_AUTHORITY_RESOLVER = (string, uRIAuthority) -> {
        if (uRIAuthority != null && uRIAuthority.getPort() != -1) {
            return new URIAuthority(uRIAuthority.getHostName(), -1);
        }
        return uRIAuthority;
    };
    private final Function<URIAuthority, Function<String, T>> authorityRouter;
    private final BiFunction<String, URIAuthority, URIAuthority> authorityResolver;
    private final HttpRequestMapper<T> downstream;

    @Internal
    public static <T> RequestRouter<T> create(URIAuthority object, UriPatternType uriPatternType, List<RequestRouter$Entry<T>> list2, BiFunction<String, URIAuthority, URIAuthority> biFunction, HttpRequestMapper<T> httpRequestMapper) {
        object = list2.stream().collect(Collectors.groupingBy(arg_0 -> RequestRouter.lambda$create$0((URIAuthority)object, arg_0), Collectors.mapping(requestRouter$Entry -> requestRouter$Entry.route, Collectors.collectingAndThen(Collectors.toList(), list -> {
            switch (uriPatternType) {
                case URI_PATTERN: {
                    return UriPathRouter.bestMatch(list);
                }
                case URI_PATTERN_IN_ORDER: {
                    return UriPathRouter.ordered(list);
                }
                case REGEX: {
                    return UriPathRouter.regEx(list);
                }
            }
            throw new IllegalStateException("Unexpected pattern type: " + (Object)((Object)uriPatternType));
        }))));
        if (object.isEmpty()) {
            object = new RequestRouter$NoAuthorityResolver<Function<String, T>>();
        } else if (object.size() == 1) {
            object = object.entrySet().iterator().next();
            object = new RequestRouter$SingleAuthorityResolver((URIAuthority)object.getKey(), object.getValue());
        } else {
            object = arg_0 -> object.get(arg_0);
        }
        return new RequestRouter<T>(object, biFunction, httpRequestMapper);
    }

    public static <T> RequestRouter$Builder<T> builder(UriPatternType uriPatternType) {
        return new RequestRouter$Builder(uriPatternType);
    }

    public static <T> RequestRouter$Builder<T> builder() {
        return new RequestRouter$Builder(UriPatternType.URI_PATTERN);
    }

    RequestRouter(Function<URIAuthority, Function<String, T>> function, BiFunction<String, URIAuthority, URIAuthority> biFunction, HttpRequestMapper<T> httpRequestMapper) {
        this.authorityRouter = function;
        this.authorityResolver = biFunction;
        this.downstream = httpRequestMapper;
    }

    @Override
    public T resolve(HttpRequest object, HttpContext httpContext) throws HttpException {
        URIAuthority uRIAuthority = this.authorityResolver != null ? this.authorityResolver.apply(object.getScheme(), object.getAuthority()) : object.getAuthority();
        if ((uRIAuthority = uRIAuthority != null ? this.authorityRouter.apply(uRIAuthority) : null) == null) {
            if (this.downstream != null) {
                return this.downstream.resolve((HttpRequest)object, httpContext);
            }
            throw new MisdirectedRequestException("Not authoritative");
        }
        int n2 = ((String)(object = object.getPath())).indexOf(63);
        if (n2 != -1) {
            object = ((String)object).substring(0, n2);
        }
        return (T)uRIAuthority.apply(object);
    }

    private static /* synthetic */ URIAuthority lambda$create$0(URIAuthority uRIAuthority, RequestRouter$Entry requestRouter$Entry) {
        if (requestRouter$Entry.uriAuthority != null) {
            return requestRouter$Entry.uriAuthority;
        }
        if (uRIAuthority != null) {
            return uRIAuthority;
        }
        return LOCAL_AUTHORITY;
    }
}

