/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.routing;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hc.core5.http.impl.routing.PathPatternMatcher;
import org.apache.hc.core5.http.impl.routing.PathRoute;
import org.apache.hc.core5.http.impl.routing.UriPathRouter$BestMatcher;
import org.apache.hc.core5.http.impl.routing.UriPathRouter$OrderedMatcher;
import org.apache.hc.core5.http.impl.routing.UriPathRouter$RegexMatcher;

final class UriPathRouter<P, T>
implements Function<String, T> {
    private final BiFunction<String, List<PathRoute<P, T>>, T> pathRouter;
    private final List<PathRoute<P, T>> routes;
    private static final PathPatternMatcher PATH_PATTERN_MATCHER = PathPatternMatcher.INSTANCE;

    UriPathRouter(Function<String, P> function, BiFunction<String, List<PathRoute<P, T>>, T> biFunction, List<PathRoute<String, T>> list) {
        this.pathRouter = biFunction;
        this.routes = Collections.unmodifiableList(list.stream().map(pathRoute -> new PathRoute(function.apply((String)pathRoute.pattern), pathRoute.handler)).collect(Collectors.toList()));
    }

    @Override
    public final T apply(String string) {
        return this.pathRouter.apply(string, this.routes);
    }

    public final String toString() {
        return this.routes.toString();
    }

    static <T> UriPathRouter<?, T> bestMatch(List<PathRoute<String, T>> list) {
        return new UriPathRouter<String, T>(string -> string, new UriPathRouter$BestMatcher(), list);
    }

    static <T> UriPathRouter<?, T> ordered(List<PathRoute<String, T>> list) {
        return new UriPathRouter<String, T>(string -> string, new UriPathRouter$OrderedMatcher(), list);
    }

    static <T> UriPathRouter<?, T> regEx(List<PathRoute<String, T>> list) {
        return new UriPathRouter<Pattern, T>(Pattern::compile, new UriPathRouter$RegexMatcher(), list);
    }

    static /* synthetic */ PathPatternMatcher access$000() {
        return PATH_PATTERN_MATCHER;
    }
}

