/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io;

import java.net.SocketAddress;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.io.SocketConfig$Builder;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class SocketConfig {
    private static final Timeout DEFAULT_SOCKET_TIMEOUT = Timeout.ofMinutes(3L);
    public static final SocketConfig DEFAULT = new SocketConfig$Builder().build();
    private final Timeout soTimeout;
    private final boolean soReuseAddress;
    private final TimeValue soLinger;
    private final boolean soKeepAlive;
    private final boolean tcpNoDelay;
    private final int sndBufSize;
    private final int rcvBufSize;
    private final int backlogSize;
    private final int tcpKeepIdle;
    private final int tcpKeepInterval;
    private final int tcpKeepCount;
    private final SocketAddress socksProxyAddress;

    SocketConfig(Timeout timeout, boolean bl2, TimeValue timeValue, boolean bl3, boolean bl4, int n2, int n3, int n4, int n5, int n6, int n7, SocketAddress socketAddress) {
        this.soTimeout = timeout;
        this.soReuseAddress = bl2;
        this.soLinger = timeValue;
        this.soKeepAlive = bl3;
        this.tcpNoDelay = bl4;
        this.sndBufSize = n2;
        this.rcvBufSize = n3;
        this.backlogSize = n4;
        this.tcpKeepIdle = n5;
        this.tcpKeepInterval = n6;
        this.tcpKeepCount = n7;
        this.socksProxyAddress = socketAddress;
    }

    public Timeout getSoTimeout() {
        return this.soTimeout;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public TimeValue getSoLinger() {
        return this.soLinger;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getSndBufSize() {
        return this.sndBufSize;
    }

    public int getRcvBufSize() {
        return this.rcvBufSize;
    }

    public int getBacklogSize() {
        return this.backlogSize;
    }

    public int getTcpKeepIdle() {
        return this.tcpKeepIdle;
    }

    public int getTcpKeepInterval() {
        return this.tcpKeepInterval;
    }

    public int getTcpKeepCount() {
        return this.tcpKeepCount;
    }

    public SocketAddress getSocksProxyAddress() {
        return this.socksProxyAddress;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[soTimeout=").append(this.soTimeout).append(", soReuseAddress=").append(this.soReuseAddress).append(", soLinger=").append(this.soLinger).append(", soKeepAlive=").append(this.soKeepAlive).append(", tcpNoDelay=").append(this.tcpNoDelay).append(", sndBufSize=").append(this.sndBufSize).append(", rcvBufSize=").append(this.rcvBufSize).append(", backlogSize=").append(this.backlogSize).append(", tcpKeepIdle=").append(this.tcpKeepIdle).append(", tcpKeepInterval=").append(this.tcpKeepInterval).append(", tcpKeepCount=").append(this.tcpKeepCount).append(", socksProxyAddress=").append(this.socksProxyAddress).append("]");
        return stringBuilder.toString();
    }

    public static SocketConfig$Builder custom() {
        return new SocketConfig$Builder();
    }

    public static SocketConfig$Builder copy(SocketConfig socketConfig) {
        Args.notNull(socketConfig, "Socket config");
        return new SocketConfig$Builder().setSoTimeout(socketConfig.getSoTimeout()).setSoReuseAddress(socketConfig.isSoReuseAddress()).setSoLinger(socketConfig.getSoLinger()).setSoKeepAlive(socketConfig.isSoKeepAlive()).setTcpNoDelay(socketConfig.isTcpNoDelay()).setSndBufSize(socketConfig.getSndBufSize()).setRcvBufSize(socketConfig.getRcvBufSize()).setBacklogSize(socketConfig.getBacklogSize()).setTcpKeepIdle(socketConfig.getTcpKeepIdle()).setTcpKeepInterval(socketConfig.getTcpKeepInterval()).setTcpKeepCount(socketConfig.getTcpKeepCount()).setSocksProxyAddress(socketConfig.getSocksProxyAddress());
    }

    static /* synthetic */ Timeout access$000() {
        return DEFAULT_SOCKET_TIMEOUT;
    }
}

