/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.util.Args;

public abstract class AbstractHttpEntity
implements HttpEntity {
    static final int OUTPUT_BUFFER_SIZE = 4096;
    private final String contentType;
    private final String contentEncoding;
    private final boolean chunked;

    protected AbstractHttpEntity(String string, String string2, boolean bl2) {
        this.contentType = string;
        this.contentEncoding = string2;
        this.chunked = bl2;
    }

    protected AbstractHttpEntity(ContentType contentType, String string, boolean bl2) {
        this.contentType = Objects.toString(contentType, null);
        this.contentEncoding = string;
        this.chunked = bl2;
    }

    protected AbstractHttpEntity(String string, String string2) {
        this(string, string2, false);
    }

    protected AbstractHttpEntity(ContentType contentType, String string) {
        this(contentType, string, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeTo(HttpEntity closeable, OutputStream outputStream) throws IOException {
        Args.notNull(closeable, "Entity");
        Args.notNull(outputStream, "Output stream");
        closeable = closeable.getContent();
        Throwable throwable = null;
        try {
            if (closeable != null) {
                int n2;
                byte[] byArray = new byte[4096];
                while ((n2 = ((InputStream)closeable).read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n2);
                }
            }
            if (closeable == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (closeable == null) throw throwable4;
                if (throwable != null) {
                    try {
                        ((InputStream)closeable).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    ((InputStream)closeable).close();
                }
                throw throwable4;
            }
        }
        ((InputStream)closeable).close();
        return;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        AbstractHttpEntity.writeTo(this, outputStream);
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public final String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public final boolean isChunked() {
        return this.chunked;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public Supplier<List<? extends Header>> getTrailers() {
        return null;
    }

    @Override
    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Entity-Class: ");
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(", Content-Type: ");
        stringBuilder.append(this.contentType);
        stringBuilder.append(", Content-Encoding: ");
        stringBuilder.append(this.contentEncoding);
        stringBuilder.append(", chunked: ");
        stringBuilder.append(this.chunked);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

