/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.net.WWWFormCodec;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;

public final class EntityUtils {
    private static final int DEFAULT_ENTITY_RETURN_MAX_LENGTH = Integer.MAX_VALUE;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 1024;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 4096;
    private static final Map<String, ContentType> CONTENT_TYPE_MAP;

    private EntityUtils() {
    }

    public static void consumeQuietly(HttpEntity httpEntity) {
        try {
            EntityUtils.consume(httpEntity);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void consume(HttpEntity httpEntity) throws IOException {
        if (httpEntity == null) {
            return;
        }
        if (httpEntity.isStreaming()) {
            Closer.close(httpEntity.getContent());
        }
    }

    private static int toContentLength(int n2) {
        if (n2 < 0) {
            return 4096;
        }
        return n2;
    }

    static long checkContentLength(EntityDetails entityDetails) {
        return Args.checkRange(entityDetails.getContentLength(), -1L, Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory)");
    }

    public static byte[] toByteArray(HttpEntity closeable) throws IOException {
        Object object;
        block12: {
            Args.notNull(closeable, "HttpEntity");
            int n2 = EntityUtils.toContentLength((int)EntityUtils.checkContentLength((EntityDetails)((Object)closeable)));
            closeable = closeable.getContent();
            Throwable throwable = null;
            if (closeable == null) {
                if (closeable != null) {
                    ((InputStream)closeable).close();
                }
                return null;
            }
            try {
                int n3;
                object = new ByteArrayBuffer(n2);
                byte[] byArray = new byte[4096];
                while ((n3 = ((InputStream)closeable).read(byArray)) != -1) {
                    ((ByteArrayBuffer)object).append(byArray, 0, n3);
                }
                object = ((ByteArrayBuffer)object).toByteArray();
                if (closeable == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (closeable != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)closeable).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)closeable).close();
                        }
                    }
                    throw throwable4;
                }
            }
            ((InputStream)closeable).close();
        }
        return object;
    }

    public static byte[] toByteArray(HttpEntity closeable, int n2) throws IOException {
        byte[] byArray;
        block12: {
            Args.notNull(closeable, "HttpEntity");
            int n3 = EntityUtils.toContentLength((int)EntityUtils.checkContentLength((EntityDetails)((Object)closeable)));
            closeable = closeable.getContent();
            Throwable throwable = null;
            if (closeable == null) {
                if (closeable != null) {
                    ((InputStream)closeable).close();
                }
                return null;
            }
            try {
                int n4;
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(Math.min(n2, n3));
                byte[] byArray2 = new byte[4096];
                while ((n4 = ((InputStream)closeable).read(byArray2)) != -1 && byteArrayBuffer.length() < n2) {
                    byteArrayBuffer.append(byArray2, 0, n4);
                }
                ByteArrayBuffer byteArrayBuffer2 = byteArrayBuffer;
                byteArrayBuffer2.setLength(Math.min(byteArrayBuffer2.length(), n2));
                byArray = byteArrayBuffer.toByteArray();
                if (closeable == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (closeable != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)closeable).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)closeable).close();
                        }
                    }
                    throw throwable4;
                }
            }
            ((InputStream)closeable).close();
        }
        return byArray;
    }

    private static CharArrayBuffer toCharArrayBuffer(InputStream closeable, int n2, Charset object, int n3) throws IOException {
        int n4;
        Args.notNull(closeable, "InputStream");
        Args.positive(n3, "maxResultLength");
        object = object == null ? DEFAULT_CHARSET : object;
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(Math.min(n3, n2 > 0 ? n2 : 1024));
        closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
        object = new char[1024];
        while ((n4 = ((Reader)closeable).read((char[])object)) != -1 && charArrayBuffer.length() < n3) {
            charArrayBuffer.append((char[])object, 0, n4);
        }
        CharArrayBuffer charArrayBuffer2 = charArrayBuffer;
        charArrayBuffer2.setLength(Math.min(charArrayBuffer2.length(), n3));
        return charArrayBuffer;
    }

    private static String toString(HttpEntity closeable, ContentType object, int n2) throws IOException {
        block12: {
            Args.notNull(closeable, "HttpEntity");
            int n3 = EntityUtils.toContentLength((int)EntityUtils.checkContentLength((EntityDetails)((Object)closeable)));
            closeable = closeable.getContent();
            Throwable throwable = null;
            if (closeable == null) {
                if (closeable != null) {
                    ((InputStream)closeable).close();
                }
                return null;
            }
            try {
                Charset charset = null;
                if (object != null && (charset = ((ContentType)object).getCharset()) == null) {
                    charset = (object = CONTENT_TYPE_MAP.get(((ContentType)object).getMimeType())) != null ? ((ContentType)object).getCharset() : null;
                }
                object = EntityUtils.toCharArrayBuffer((InputStream)closeable, n3, charset, n2).toString();
                if (closeable == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (closeable != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)closeable).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)closeable).close();
                        }
                    }
                    throw throwable4;
                }
            }
            ((InputStream)closeable).close();
        }
        return object;
    }

    public static String toString(HttpEntity httpEntity, Charset charset) throws IOException, ParseException {
        return EntityUtils.toString(httpEntity, charset, Integer.MAX_VALUE);
    }

    public static String toString(HttpEntity httpEntity, Charset charset, int n2) throws IOException, ParseException {
        ContentType contentType;
        block5: {
            Args.notNull(httpEntity, "HttpEntity");
            contentType = null;
            try {
                contentType = ContentType.parse(httpEntity.getContentType());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                if (charset != null) break block5;
                throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
            }
        }
        if (contentType != null) {
            if (contentType.getCharset() == null) {
                contentType = contentType.withCharset(charset);
            }
        } else {
            contentType = ContentType.DEFAULT_TEXT.withCharset(charset);
        }
        return EntityUtils.toString(httpEntity, contentType, n2);
    }

    public static String toString(HttpEntity httpEntity, String string) throws IOException, ParseException {
        return EntityUtils.toString(httpEntity, string, Integer.MAX_VALUE);
    }

    public static String toString(HttpEntity httpEntity, String string, int n2) throws IOException, ParseException {
        return EntityUtils.toString(httpEntity, string != null ? Charset.forName(string) : null, n2);
    }

    public static String toString(HttpEntity httpEntity) throws IOException, ParseException {
        return EntityUtils.toString(httpEntity, Integer.MAX_VALUE);
    }

    public static String toString(HttpEntity httpEntity, int n2) throws IOException, ParseException {
        Args.notNull(httpEntity, "HttpEntity");
        HttpEntity httpEntity2 = httpEntity;
        return EntityUtils.toString(httpEntity2, ContentType.parse(httpEntity2.getContentType()), n2);
    }

    public static List<NameValuePair> parse(HttpEntity httpEntity) throws IOException {
        return EntityUtils.parse(httpEntity, Integer.MAX_VALUE);
    }

    /*
     * Unable to fully structure code
     */
    public static List<NameValuePair> parse(HttpEntity var0, int var1_2) throws IOException {
        block13: {
            block14: {
                Args.notNull(var0, "HttpEntity");
                var2_4 = EntityUtils.toContentLength((int)EntityUtils.checkContentLength((EntityDetails)var0));
                var3_5 = ContentType.parse(var0.getContentType());
                if (!ContentType.APPLICATION_FORM_URLENCODED.isSameMimeType((ContentType)var3_5)) {
                    return Collections.emptyList();
                }
                var3_5 = var3_5.getCharset(EntityUtils.DEFAULT_CHARSET);
                var4_6 = var0.getContent();
                var5_7 = null;
                if (var4_6 != null) break block13;
                var0 = Collections.emptyList();
                if (var4_6 == null) break block14;
                var4_6.close();
            }
            return var0;
        }
        try {
            var0 = EntityUtils.toCharArrayBuffer(var4_6, var2_4, (Charset)var3_5, var1_2);
            ** if (var4_6 == null) goto lbl-1000
        }
        catch (Throwable v0) {
            try {
                var0 = v0;
                var5_7 = v0;
                throw var0;
            }
            catch (Throwable var0_1) {
                if (var4_6 != null) {
                    if (var5_7 != null) {
                        try {
                            var4_6.close();
                        }
                        catch (Throwable var1_3) {
                            var5_7.addSuppressed(var1_3);
                        }
                    } else {
                        var4_6.close();
                    }
                }
                throw var0_1;
            }
        }
lbl-1000:
        // 1 sources

        {
            var4_6.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var0.isEmpty()) {
            return Collections.emptyList();
        }
        return WWWFormCodec.parse((CharSequence)var0, (Charset)var3_5);
    }

    static {
        ContentType[] contentTypeArray = new ContentType[]{ContentType.APPLICATION_ATOM_XML, ContentType.APPLICATION_FORM_URLENCODED, ContentType.APPLICATION_JSON, ContentType.APPLICATION_SVG_XML, ContentType.APPLICATION_XHTML_XML, ContentType.APPLICATION_XML, ContentType.MULTIPART_FORM_DATA, ContentType.TEXT_HTML, ContentType.TEXT_PLAIN, ContentType.TEXT_XML};
        HashMap<String, ContentType> hashMap = new HashMap<String, ContentType>();
        int cfr_ignored_0 = contentTypeArray.length;
        for (int i2 = 0; i2 < 10; ++i2) {
            ContentType contentType = contentTypeArray[i2];
            hashMap.put(contentType.getMimeType(), contentType);
        }
        CONTENT_TYPE_MAP = Collections.unmodifiableMap(hashMap);
    }
}

