/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityTemplate;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.HttpEntities$1;
import org.apache.hc.core5.http.io.entity.HttpEntities$2;
import org.apache.hc.core5.http.io.entity.PathEntity;
import org.apache.hc.core5.http.io.entity.SerializableEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.io.IOCallback;
import org.apache.hc.core5.net.WWWFormCodec;

public final class HttpEntities {
    private HttpEntities() {
    }

    public static HttpEntity create(String string, ContentType contentType) {
        return new StringEntity(string, contentType);
    }

    public static HttpEntity create(String string, Charset charset) {
        return new StringEntity(string, ContentType.TEXT_PLAIN.withCharset(charset));
    }

    public static HttpEntity create(String string) {
        return new StringEntity(string, ContentType.TEXT_PLAIN);
    }

    public static HttpEntity create(byte[] byArray, ContentType contentType) {
        return new ByteArrayEntity(byArray, contentType);
    }

    public static HttpEntity create(File file, ContentType contentType) {
        return new FileEntity(file, contentType);
    }

    public static HttpEntity create(Serializable serializable, ContentType contentType) {
        return new SerializableEntity(serializable, contentType);
    }

    public static HttpEntity createUrlEncoded(Iterable<? extends NameValuePair> iterable, Charset object) {
        object = object != null ? ContentType.APPLICATION_FORM_URLENCODED.withCharset((Charset)object) : ContentType.APPLICATION_FORM_URLENCODED;
        return HttpEntities.create(WWWFormCodec.format(iterable, ((ContentType)object).getCharset()), (ContentType)object);
    }

    public static HttpEntity create(IOCallback<OutputStream> iOCallback, ContentType contentType) {
        return new EntityTemplate(-1L, contentType, null, iOCallback);
    }

    public static HttpEntity gzip(HttpEntity httpEntity) {
        return new HttpEntities$1(httpEntity);
    }

    public static HttpEntity createGzipped(String string, ContentType contentType) {
        return HttpEntities.gzip(HttpEntities.create(string, contentType));
    }

    public static HttpEntity createGzipped(String string, Charset charset) {
        return HttpEntities.gzip(HttpEntities.create(string, charset));
    }

    public static HttpEntity createGzipped(String string) {
        return HttpEntities.gzip(HttpEntities.create(string));
    }

    public static HttpEntity createGzipped(byte[] byArray, ContentType contentType) {
        return HttpEntities.gzip(HttpEntities.create(byArray, contentType));
    }

    public static HttpEntity createGzipped(File file, ContentType contentType) {
        return HttpEntities.gzip(HttpEntities.create(file, contentType));
    }

    public static HttpEntity createGzipped(Serializable serializable, ContentType contentType) {
        return HttpEntities.gzip(HttpEntities.create(serializable, contentType));
    }

    public static HttpEntity createGzipped(IOCallback<OutputStream> iOCallback, ContentType contentType) {
        return HttpEntities.gzip(HttpEntities.create(iOCallback, contentType));
    }

    public static HttpEntity createGzipped(Path path, ContentType contentType) {
        return HttpEntities.gzip(HttpEntities.create(path, contentType));
    }

    public static HttpEntity withTrailers(HttpEntity httpEntity, Header ... headerArray) {
        return new HttpEntities$2(httpEntity, headerArray);
    }

    public static HttpEntity create(String string, ContentType contentType, Header ... headerArray) {
        return HttpEntities.withTrailers(HttpEntities.create(string, contentType), headerArray);
    }

    public static HttpEntity create(String string, Charset charset, Header ... headerArray) {
        return HttpEntities.withTrailers(HttpEntities.create(string, charset), headerArray);
    }

    public static HttpEntity create(String string, Header ... headerArray) {
        return HttpEntities.withTrailers(HttpEntities.create(string), headerArray);
    }

    public static HttpEntity create(byte[] byArray, ContentType contentType, Header ... headerArray) {
        return HttpEntities.withTrailers(HttpEntities.create(byArray, contentType), headerArray);
    }

    public static HttpEntity create(File file, ContentType contentType, Header ... headerArray) {
        return HttpEntities.withTrailers(HttpEntities.create(file, contentType), headerArray);
    }

    public static HttpEntity create(Serializable serializable, ContentType contentType, Header ... headerArray) {
        return HttpEntities.withTrailers(HttpEntities.create(serializable, contentType), headerArray);
    }

    public static HttpEntity create(IOCallback<OutputStream> iOCallback, ContentType contentType, Header ... headerArray) {
        return HttpEntities.withTrailers(HttpEntities.create(iOCallback, contentType), headerArray);
    }

    public static HttpEntity create(Path path, ContentType contentType) {
        return new PathEntity(path, contentType);
    }

    public static HttpEntity create(Path path, ContentType contentType, Header ... headerArray) {
        return HttpEntities.withTrailers(HttpEntities.create(path, contentType), headerArray);
    }
}

