/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.support;

import java.io.IOException;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.HttpServerRequestHandler$ResponseTrigger;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class BasicHttpServerRequestHandler
implements HttpServerRequestHandler {
    private final HttpRequestMapper<HttpRequestHandler> handlerMapper;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public BasicHttpServerRequestHandler(HttpRequestMapper<HttpRequestHandler> httpRequestMapper, HttpResponseFactory<ClassicHttpResponse> defaultClassicHttpResponseFactory) {
        this.handlerMapper = Args.notNull(httpRequestMapper, "Handler mapper");
        this.responseFactory = defaultClassicHttpResponseFactory != null ? defaultClassicHttpResponseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    public BasicHttpServerRequestHandler(HttpRequestMapper<HttpRequestHandler> httpRequestMapper) {
        this(httpRequestMapper, null);
    }

    @Override
    public void handle(ClassicHttpRequest classicHttpRequest, HttpServerRequestHandler$ResponseTrigger httpServerRequestHandler$ResponseTrigger, HttpContext httpContext) throws HttpException, IOException {
        ClassicHttpResponse classicHttpResponse = this.responseFactory.newHttpResponse(200);
        HttpRequestHandler httpRequestHandler = this.handlerMapper != null ? this.handlerMapper.resolve(classicHttpRequest, httpContext) : null;
        if (httpRequestHandler != null) {
            httpRequestHandler.handle(classicHttpRequest, classicHttpResponse, httpContext);
        } else {
            classicHttpResponse.setCode(501);
        }
        httpServerRequestHandler$ResponseTrigger.submitResponse(classicHttpResponse);
    }
}

