/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.http.support.AbstractRequestBuilder;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

public class ClassicRequestBuilder
extends AbstractRequestBuilder<ClassicHttpRequest> {
    private HttpEntity entity;

    ClassicRequestBuilder(String string) {
        super(string);
    }

    ClassicRequestBuilder(Method method) {
        super(method);
    }

    ClassicRequestBuilder(String string, URI uRI) {
        super(string, uRI);
    }

    ClassicRequestBuilder(Method method, URI uRI) {
        super(method, uRI);
    }

    ClassicRequestBuilder(Method method, String string) {
        super(method, string);
    }

    ClassicRequestBuilder(String string, String string2) {
        super(string, string2);
    }

    public static ClassicRequestBuilder create(String string) {
        Args.notBlank(string, "HTTP method");
        return new ClassicRequestBuilder(string);
    }

    public static ClassicRequestBuilder get() {
        return new ClassicRequestBuilder(Method.GET);
    }

    public static ClassicRequestBuilder get(URI uRI) {
        return new ClassicRequestBuilder(Method.GET, uRI);
    }

    public static ClassicRequestBuilder get(String string) {
        return new ClassicRequestBuilder(Method.GET, string);
    }

    public static ClassicRequestBuilder head() {
        return new ClassicRequestBuilder(Method.HEAD);
    }

    public static ClassicRequestBuilder head(URI uRI) {
        return new ClassicRequestBuilder(Method.HEAD, uRI);
    }

    public static ClassicRequestBuilder head(String string) {
        return new ClassicRequestBuilder(Method.HEAD, string);
    }

    public static ClassicRequestBuilder patch() {
        return new ClassicRequestBuilder(Method.PATCH);
    }

    public static ClassicRequestBuilder patch(URI uRI) {
        return new ClassicRequestBuilder(Method.PATCH, uRI);
    }

    public static ClassicRequestBuilder patch(String string) {
        return new ClassicRequestBuilder(Method.PATCH, string);
    }

    public static ClassicRequestBuilder post() {
        return new ClassicRequestBuilder(Method.POST);
    }

    public static ClassicRequestBuilder post(URI uRI) {
        return new ClassicRequestBuilder(Method.POST, uRI);
    }

    public static ClassicRequestBuilder post(String string) {
        return new ClassicRequestBuilder(Method.POST, string);
    }

    public static ClassicRequestBuilder put() {
        return new ClassicRequestBuilder(Method.PUT);
    }

    public static ClassicRequestBuilder put(URI uRI) {
        return new ClassicRequestBuilder(Method.PUT, uRI);
    }

    public static ClassicRequestBuilder put(String string) {
        return new ClassicRequestBuilder(Method.PUT, string);
    }

    public static ClassicRequestBuilder delete() {
        return new ClassicRequestBuilder(Method.DELETE);
    }

    public static ClassicRequestBuilder delete(URI uRI) {
        return new ClassicRequestBuilder(Method.DELETE, uRI);
    }

    public static ClassicRequestBuilder delete(String string) {
        return new ClassicRequestBuilder(Method.DELETE, string);
    }

    public static ClassicRequestBuilder trace() {
        return new ClassicRequestBuilder(Method.TRACE);
    }

    public static ClassicRequestBuilder trace(URI uRI) {
        return new ClassicRequestBuilder(Method.TRACE, uRI);
    }

    public static ClassicRequestBuilder trace(String string) {
        return new ClassicRequestBuilder(Method.TRACE, string);
    }

    public static ClassicRequestBuilder options() {
        return new ClassicRequestBuilder(Method.OPTIONS);
    }

    public static ClassicRequestBuilder options(URI uRI) {
        return new ClassicRequestBuilder(Method.OPTIONS, uRI);
    }

    public static ClassicRequestBuilder options(String string) {
        return new ClassicRequestBuilder(Method.OPTIONS, string);
    }

    public static ClassicRequestBuilder copy(ClassicHttpRequest classicHttpRequest) {
        Args.notNull(classicHttpRequest, "HTTP request");
        ClassicRequestBuilder classicRequestBuilder = new ClassicRequestBuilder(classicHttpRequest.getMethod());
        classicRequestBuilder.digest(classicHttpRequest);
        return classicRequestBuilder;
    }

    protected void digest(ClassicHttpRequest classicHttpRequest) {
        super.digest(classicHttpRequest);
        this.setEntity(classicHttpRequest.getEntity());
    }

    @Override
    public ClassicRequestBuilder setVersion(ProtocolVersion protocolVersion) {
        super.setVersion(protocolVersion);
        return this;
    }

    public ClassicRequestBuilder setUri(URI uRI) {
        super.setUri(uRI);
        return this;
    }

    public ClassicRequestBuilder setUri(String string) {
        super.setUri(string);
        return this;
    }

    public ClassicRequestBuilder setScheme(String string) {
        super.setScheme(string);
        return this;
    }

    public ClassicRequestBuilder setAuthority(URIAuthority uRIAuthority) {
        super.setAuthority(uRIAuthority);
        return this;
    }

    public ClassicRequestBuilder setHttpHost(HttpHost httpHost) {
        super.setHttpHost(httpHost);
        return this;
    }

    public ClassicRequestBuilder setPath(String string) {
        super.setPath(string);
        return this;
    }

    @Override
    public ClassicRequestBuilder setHeaders(Header ... headerArray) {
        super.setHeaders(headerArray);
        return this;
    }

    @Override
    public ClassicRequestBuilder addHeader(Header header) {
        super.addHeader(header);
        return this;
    }

    @Override
    public ClassicRequestBuilder addHeader(String string, String string2) {
        super.addHeader(string, string2);
        return this;
    }

    @Override
    public ClassicRequestBuilder removeHeader(Header header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public ClassicRequestBuilder removeHeaders(String string) {
        super.removeHeaders(string);
        return this;
    }

    @Override
    public ClassicRequestBuilder setHeader(Header header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public ClassicRequestBuilder setHeader(String string, String string2) {
        super.setHeader(string, string2);
        return this;
    }

    public ClassicRequestBuilder setCharset(Charset charset) {
        super.setCharset(charset);
        return this;
    }

    public ClassicRequestBuilder addParameter(NameValuePair nameValuePair) {
        super.addParameter(nameValuePair);
        return this;
    }

    public ClassicRequestBuilder addParameter(String string, String string2) {
        super.addParameter(string, string2);
        return this;
    }

    public ClassicRequestBuilder addParameters(NameValuePair ... nameValuePairArray) {
        super.addParameters(nameValuePairArray);
        return this;
    }

    public ClassicRequestBuilder setAbsoluteRequestUri(boolean bl2) {
        super.setAbsoluteRequestUri(bl2);
        return this;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public ClassicRequestBuilder setEntity(HttpEntity httpEntity) {
        this.entity = httpEntity;
        return this;
    }

    public ClassicRequestBuilder setEntity(String string, ContentType contentType) {
        this.entity = new StringEntity(string, contentType);
        return this;
    }

    public ClassicRequestBuilder setEntity(String string) {
        this.entity = new StringEntity(string);
        return this;
    }

    public ClassicRequestBuilder setEntity(byte[] byArray, ContentType contentType) {
        this.entity = new ByteArrayEntity(byArray, contentType);
        return this;
    }

    @Override
    public ClassicHttpRequest build() {
        String string = this.getPath();
        if (TextUtils.isEmpty(string)) {
            string = "/";
        }
        HttpEntity httpEntity = this.entity;
        String string2 = this.getMethod();
        List<NameValuePair> list = this.getParameters();
        if (list != null && !list.isEmpty()) {
            if (httpEntity == null && (Method.POST.isSame(string2) || Method.PUT.isSame(string2))) {
                httpEntity = HttpEntities.createUrlEncoded(list, this.getCharset());
            } else {
                try {
                    list = new URIBuilder(string).setCharset(this.getCharset()).addParameters(list).build();
                    string = ((URI)((Object)list)).toASCIIString();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        if (httpEntity != null && Method.TRACE.isSame(string2)) {
            throw new IllegalStateException((Object)((Object)Method.TRACE) + " requests may not include an entity");
        }
        list = new BasicClassicHttpRequest(string2, this.getScheme(), this.getAuthority(), string);
        ((BasicHttpRequest)((Object)list)).setVersion(this.getVersion());
        ((HeaderGroup)((Object)list)).setHeaders(this.getHeaders());
        ((BasicClassicHttpRequest)((Object)list)).setEntity(httpEntity);
        ((BasicHttpRequest)((Object)list)).setAbsoluteRequestUri(this.isAbsoluteRequestUri());
        return list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ClassicRequestBuilder [method=");
        stringBuilder.append(this.getMethod());
        stringBuilder.append(", scheme=");
        stringBuilder.append(this.getScheme());
        stringBuilder.append(", authority=");
        stringBuilder.append(this.getAuthority());
        stringBuilder.append(", path=");
        stringBuilder.append(this.getPath());
        stringBuilder.append(", parameters=");
        stringBuilder.append(this.getParameters());
        stringBuilder.append(", headerGroup=");
        stringBuilder.append(Arrays.toString(this.getHeaders()));
        stringBuilder.append(", entity=");
        stringBuilder.append(this.entity != null ? this.entity.getClass() : null);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

