/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.support;

import java.util.Arrays;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.support.AbstractResponseBuilder;
import org.apache.hc.core5.util.Args;

public class ClassicResponseBuilder
extends AbstractResponseBuilder<ClassicHttpResponse> {
    private HttpEntity entity;

    ClassicResponseBuilder(int n2) {
        super(n2);
    }

    public static ClassicResponseBuilder create(int n2) {
        Args.checkRange(n2, 100, 599, "HTTP status code");
        return new ClassicResponseBuilder(n2);
    }

    public static ClassicResponseBuilder copy(ClassicHttpResponse classicHttpResponse) {
        Args.notNull(classicHttpResponse, "HTTP response");
        ClassicResponseBuilder classicResponseBuilder = new ClassicResponseBuilder(classicHttpResponse.getCode());
        classicResponseBuilder.digest(classicHttpResponse);
        return classicResponseBuilder;
    }

    protected void digest(ClassicHttpResponse classicHttpResponse) {
        super.digest(classicHttpResponse);
        this.setEntity(classicHttpResponse.getEntity());
    }

    @Override
    public ClassicResponseBuilder setVersion(ProtocolVersion protocolVersion) {
        super.setVersion(protocolVersion);
        return this;
    }

    @Override
    public ClassicResponseBuilder setHeaders(Header ... headerArray) {
        super.setHeaders(headerArray);
        return this;
    }

    @Override
    public ClassicResponseBuilder addHeader(Header header) {
        super.addHeader(header);
        return this;
    }

    @Override
    public ClassicResponseBuilder addHeader(String string, String string2) {
        super.addHeader(string, string2);
        return this;
    }

    @Override
    public ClassicResponseBuilder removeHeader(Header header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public ClassicResponseBuilder removeHeaders(String string) {
        super.removeHeaders(string);
        return this;
    }

    @Override
    public ClassicResponseBuilder setHeader(Header header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public ClassicResponseBuilder setHeader(String string, String string2) {
        super.setHeader(string, string2);
        return this;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public ClassicResponseBuilder setEntity(HttpEntity httpEntity) {
        this.entity = httpEntity;
        return this;
    }

    public ClassicResponseBuilder setEntity(String string, ContentType contentType) {
        this.entity = new StringEntity(string, contentType);
        return this;
    }

    public ClassicResponseBuilder setEntity(String string) {
        this.entity = new StringEntity(string);
        return this;
    }

    public ClassicResponseBuilder setEntity(byte[] byArray, ContentType contentType) {
        this.entity = new ByteArrayEntity(byArray, contentType);
        return this;
    }

    @Override
    public ClassicHttpResponse build() {
        BasicClassicHttpResponse basicClassicHttpResponse = new BasicClassicHttpResponse(this.getStatus());
        basicClassicHttpResponse.setVersion(this.getVersion());
        basicClassicHttpResponse.setHeaders(this.getHeaders());
        basicClassicHttpResponse.setEntity(this.entity);
        return basicClassicHttpResponse;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ClassicResponseBuilder [status=");
        stringBuilder.append(this.getStatus());
        stringBuilder.append(", headerGroup=");
        stringBuilder.append(Arrays.toString(this.getHeaders()));
        stringBuilder.append(", entity=");
        stringBuilder.append(this.entity != null ? this.entity.getClass() : null);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

