/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.support;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.io.HttpFilterChain;
import org.apache.hc.core5.http.io.HttpFilterChain$ResponseTrigger;
import org.apache.hc.core5.http.io.HttpFilterHandler;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class TerminalServerFilter
implements HttpFilterHandler {
    private final HttpRequestMapper<HttpRequestHandler> handlerMapper;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public TerminalServerFilter(HttpRequestMapper<HttpRequestHandler> httpRequestMapper, HttpResponseFactory<ClassicHttpResponse> defaultClassicHttpResponseFactory) {
        this.handlerMapper = Args.notNull(httpRequestMapper, "Handler mapper");
        this.responseFactory = defaultClassicHttpResponseFactory != null ? defaultClassicHttpResponseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    @Override
    public final void handle(ClassicHttpRequest classicHttpRequest, HttpFilterChain$ResponseTrigger httpFilterChain$ResponseTrigger, HttpContext httpContext, HttpFilterChain object) throws HttpException, IOException {
        object = this.responseFactory.newHttpResponse(200);
        HttpRequestHandler httpRequestHandler = this.handlerMapper.resolve(classicHttpRequest, httpContext);
        if (httpRequestHandler != null) {
            httpRequestHandler.handle(classicHttpRequest, (ClassicHttpResponse)object, httpContext);
        } else {
            object.setCode(501);
        }
        httpFilterChain$ResponseTrigger.submitResponse((ClassicHttpResponse)object);
    }
}

